/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.os.Parcel;
import android.os.ParcelUuid;
import android.os.Parcelable;
import android.util.SparseArray;
import androidx.annotation.NonNull;
import java.util.UUID;
import no.nordicsemi.android.mesh.transport.Message;

public final class AccessMessage
extends Message {
    private UUID label;
    protected SparseArray<byte[]> lowerTransportAccessPdu = new SparseArray();
    private byte[] accessPdu;
    private byte[] transportPdu;
    public static final Parcelable.Creator<AccessMessage> CREATOR = new Parcelable.Creator<AccessMessage>(){

        public AccessMessage createFromParcel(Parcel source) {
            return new AccessMessage(source);
        }

        public AccessMessage[] newArray(int size) {
            return new AccessMessage[size];
        }
    };

    public AccessMessage() {
        this.ctl = 0;
    }

    protected AccessMessage(Parcel source) {
        super(source);
        ParcelUuid parcelUuid = (ParcelUuid)source.readParcelable(ParcelUuid.class.getClassLoader());
        if (parcelUuid != null) {
            this.label = parcelUuid.getUuid();
        }
        this.lowerTransportAccessPdu = this.readSparseArrayToParcelable(source);
        this.accessPdu = source.createByteArray();
        this.transportPdu = source.createByteArray();
    }

    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeParcelable((Parcelable)new ParcelUuid(this.label), flags);
        this.writeSparseArrayToParcelable(dest, this.lowerTransportAccessPdu);
        dest.writeByteArray(this.accessPdu);
        dest.writeByteArray(this.transportPdu);
    }

    @Override
    public int getCtl() {
        return this.ctl;
    }

    public UUID getLabel() {
        return this.label;
    }

    public void setLabel(@NonNull UUID label) {
        this.label = label;
    }

    public final byte[] getAccessPdu() {
        return this.accessPdu;
    }

    public final void setAccessPdu(byte[] accessPdu) {
        this.accessPdu = accessPdu;
    }

    public final byte[] getUpperTransportPdu() {
        return this.transportPdu;
    }

    public final void setUpperTransportPdu(byte[] transportPdu) {
        this.transportPdu = transportPdu;
    }

    public final SparseArray<byte[]> getLowerTransportAccessPdu() {
        return this.lowerTransportAccessPdu;
    }

    public final void setLowerTransportAccessPdu(SparseArray<byte[]> lowerTransportAccessPdu) {
        this.lowerTransportAccessPdu = lowerTransportAccessPdu;
    }
}

