/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import no.nordicsemi.android.mesh.transport.ConfigMessage;

public final class ConfigNetworkTransmitSet
extends ConfigMessage {
    private static final String TAG = ConfigNetworkTransmitSet.class.getSimpleName();
    private static final int OP_CODE = 32804;
    private final int mNetworkTransmitCount;
    private final int mNetworkTransmitIntervalSteps;

    public ConfigNetworkTransmitSet(int networkTransmitCount, int networkTransmitIntervalSteps) throws IllegalArgumentException {
        if (networkTransmitCount < 0 || 7 < networkTransmitCount) {
            throw new IllegalArgumentException("Network Transmit Count must be between 0 and 7 (inclusive)");
        }
        if (networkTransmitIntervalSteps < 0 || 31 < networkTransmitIntervalSteps) {
            throw new IllegalArgumentException("Network Transmit Interval Steps must be between 0 and 31 (inclusive)");
        }
        this.mNetworkTransmitCount = networkTransmitCount;
        this.mNetworkTransmitIntervalSteps = networkTransmitIntervalSteps;
        this.assembleMessageParameters();
    }

    @Override
    final void assembleMessageParameters() {
        this.mParameters = new byte[]{(byte)(this.mNetworkTransmitIntervalSteps << 3 & 0xFF | this.mNetworkTransmitCount & 0xFF)};
    }

    @Override
    public int getOpCode() {
        return 32804;
    }

    public int getNetworkTransmitCount() {
        return this.mNetworkTransmitCount;
    }

    public int getNetworkTransmitIntervalSteps() {
        return this.mNetworkTransmitIntervalSteps;
    }
}

