/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import no.nordicsemi.android.mesh.transport.AccessMessage;
import no.nordicsemi.android.mesh.transport.ConfigStatusMessage;

public final class ConfigNetworkTransmitStatus
extends ConfigStatusMessage
implements Parcelable {
    private static final String TAG = ConfigNetworkTransmitStatus.class.getSimpleName();
    private static final int OP_CODE = 32805;
    private int mNetworkTransmitCount;
    private int mNetworkTransmitIntervalSteps;
    private static final Parcelable.Creator<ConfigNetworkTransmitStatus> CREATOR = new Parcelable.Creator<ConfigNetworkTransmitStatus>(){

        public ConfigNetworkTransmitStatus createFromParcel(Parcel in) {
            AccessMessage message = (AccessMessage)in.readParcelable(AccessMessage.class.getClassLoader());
            return new ConfigNetworkTransmitStatus(message);
        }

        public ConfigNetworkTransmitStatus[] newArray(int size) {
            return new ConfigNetworkTransmitStatus[size];
        }
    };

    public ConfigNetworkTransmitStatus(@NonNull AccessMessage message) {
        super(message);
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    @Override
    public int getOpCode() {
        return 32805;
    }

    @Override
    void parseStatusParameters() {
        byte[] payload = ((AccessMessage)this.mMessage).getAccessPdu();
        this.mNetworkTransmitCount = payload[2] & 7;
        this.mNetworkTransmitIntervalSteps = payload[2] >> 3 & 0x1F;
    }

    public int getNetworkTransmitCount() {
        return this.mNetworkTransmitCount;
    }

    public int getNetworkTransmitIntervalSteps() {
        return this.mNetworkTransmitIntervalSteps;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        AccessMessage message = (AccessMessage)this.mMessage;
        dest.writeParcelable((Parcelable)message, flags);
    }
}

