/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import androidx.annotation.NonNull;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import no.nordicsemi.android.mesh.ApplicationKey;
import no.nordicsemi.android.mesh.data.GlobalAltitude;
import no.nordicsemi.android.mesh.data.GlobalLatitude;
import no.nordicsemi.android.mesh.data.GlobalLongitude;
import no.nordicsemi.android.mesh.logger.MeshLogger;
import no.nordicsemi.android.mesh.transport.ApplicationMessage;
import no.nordicsemi.android.mesh.utils.SecureUtils;

public final class GenericLocationGlobalSetUnacknowledged
extends ApplicationMessage {
    private static final String TAG = GenericLocationGlobalSetUnacknowledged.class.getSimpleName();
    private static final int OP_CODE = 66;
    private static final int GENERIC_LOCATION_GLOBAL_SET_LENGTH = 10;
    private GlobalLatitude latitude;
    private GlobalLongitude longitude;
    private GlobalAltitude altitude;

    public GenericLocationGlobalSetUnacknowledged(@NonNull ApplicationKey appKey, @NonNull GlobalLatitude latitude, @NonNull GlobalLongitude longitude, @NonNull GlobalAltitude altitude) {
        super(appKey);
        this.latitude = latitude;
        this.longitude = longitude;
        this.altitude = altitude;
        this.assembleMessageParameters();
    }

    @Override
    void assembleMessageParameters() {
        this.mAid = SecureUtils.calculateK4(this.mAppKey.getKey());
        ByteBuffer buffer = ByteBuffer.allocate(10).order(ByteOrder.LITTLE_ENDIAN);
        MeshLogger.verbose(TAG, "Creating message");
        MeshLogger.verbose(TAG, this.latitude.toString());
        MeshLogger.verbose(TAG, this.longitude.toString());
        MeshLogger.verbose(TAG, this.altitude.toString());
        buffer.putInt(this.latitude.getEncodedValue());
        buffer.putInt(this.longitude.getEncodedValue());
        buffer.putShort(this.altitude.getEncodedValue());
        this.mParameters = buffer.array();
    }

    @Override
    public int getOpCode() {
        return 66;
    }

    @NonNull
    public GlobalLatitude getLatitude() {
        return this.latitude;
    }

    @NonNull
    public GlobalLongitude getLongitude() {
        return this.longitude;
    }

    @NonNull
    public GlobalAltitude getAltitude() {
        return this.altitude;
    }
}

