/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import no.nordicsemi.android.mesh.data.GlobalAltitude;
import no.nordicsemi.android.mesh.data.GlobalLatitude;
import no.nordicsemi.android.mesh.data.GlobalLongitude;
import no.nordicsemi.android.mesh.logger.MeshLogger;
import no.nordicsemi.android.mesh.transport.AccessMessage;
import no.nordicsemi.android.mesh.transport.ApplicationStatusMessage;
import no.nordicsemi.android.mesh.utils.MeshAddress;

public final class GenericLocationGlobalStatus
extends ApplicationStatusMessage
implements Parcelable {
    private static final String TAG = GenericLocationGlobalStatus.class.getSimpleName();
    private static final int OP_CODE = 64;
    private static final int GENERIC_LOCATION_GLOBAL_STATUS_LENGTH = 10;
    private GlobalLatitude latitude = GlobalLatitude.notConfigured();
    private GlobalLongitude longitude = GlobalLongitude.notConfigured();
    private GlobalAltitude altitude = GlobalAltitude.notConfigured();
    private static final Parcelable.Creator<GenericLocationGlobalStatus> CREATOR = new Parcelable.Creator<GenericLocationGlobalStatus>(){

        public GenericLocationGlobalStatus createFromParcel(Parcel in) {
            AccessMessage message = (AccessMessage)in.readParcelable(AccessMessage.class.getClassLoader());
            return new GenericLocationGlobalStatus(message);
        }

        public GenericLocationGlobalStatus[] newArray(int size) {
            return new GenericLocationGlobalStatus[size];
        }
    };

    public GenericLocationGlobalStatus(@NonNull AccessMessage message) {
        super(message);
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        AccessMessage message = (AccessMessage)this.mMessage;
        dest.writeParcelable((Parcelable)message, flags);
    }

    @Override
    void parseStatusParameters() {
        MeshLogger.verbose(TAG, "Received generic location global status from: " + MeshAddress.formatAddress(this.mMessage.getSrc(), true));
        if (this.mParameters.length == 10) {
            ByteBuffer buffer = ByteBuffer.wrap(this.mParameters).order(ByteOrder.LITTLE_ENDIAN);
            this.latitude = GlobalLatitude.of(buffer.getInt());
            this.longitude = GlobalLongitude.of(buffer.getInt());
            this.altitude = GlobalAltitude.of(buffer.getShort());
            MeshLogger.verbose(TAG, this.latitude.toString());
            MeshLogger.verbose(TAG, this.longitude.toString());
            MeshLogger.verbose(TAG, this.altitude.toString());
        }
    }

    @Override
    public int getOpCode() {
        return 64;
    }

    @NonNull
    public GlobalLatitude getLatitude() {
        return this.latitude;
    }

    @NonNull
    public GlobalLongitude getLongitude() {
        return this.longitude;
    }

    @NonNull
    public GlobalAltitude getAltitude() {
        return this.altitude;
    }
}

