/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import no.nordicsemi.android.mesh.ApplicationKey;
import no.nordicsemi.android.mesh.logger.MeshLogger;
import no.nordicsemi.android.mesh.transport.ApplicationMessage;

public class LightLCLightOnOffSet
extends ApplicationMessage {
    private static final String TAG = LightLCLightOnOffSet.class.getSimpleName();
    private static final int OP_CODE = 33434;
    private final Integer mTransitionSteps;
    private final Integer mTransitionResolution;
    private final Integer mDelay;
    private final boolean mState;
    private final int tId;

    public LightLCLightOnOffSet(@NonNull ApplicationKey appKey, boolean state, int tId) throws IllegalArgumentException {
        this(appKey, state, tId, null, null, null);
    }

    public LightLCLightOnOffSet(@NonNull ApplicationKey appKey, boolean state, int tId, @Nullable Integer transitionSteps, @Nullable Integer transitionResolution, @Nullable Integer delay) {
        super(appKey);
        this.mTransitionSteps = transitionSteps;
        this.mTransitionResolution = transitionResolution;
        this.mDelay = delay;
        this.mState = state;
        this.tId = tId;
        this.assembleMessageParameters();
    }

    @Override
    public int getOpCode() {
        return 33434;
    }

    @Override
    void assembleMessageParameters() {
        ByteBuffer paramsBuffer;
        this.mAid = (byte)this.mAppKey.getAid();
        MeshLogger.verbose(TAG, "State: " + (this.mState ? "ON" : "OFF"));
        if (this.mTransitionSteps == null || this.mTransitionResolution == null || this.mDelay == null) {
            paramsBuffer = ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN);
            paramsBuffer.put((byte)(this.mState ? 1 : 0));
            paramsBuffer.put((byte)this.tId);
        } else {
            MeshLogger.verbose(TAG, "Transition steps: " + this.mTransitionSteps);
            MeshLogger.verbose(TAG, "Transition step resolution: " + this.mTransitionResolution);
            paramsBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
            paramsBuffer.put((byte)(this.mState ? 1 : 0));
            paramsBuffer.put((byte)this.tId);
            paramsBuffer.put((byte)(this.mTransitionResolution << 6 | this.mTransitionSteps));
            int delay = this.mDelay;
            paramsBuffer.put((byte)delay);
        }
        this.mParameters = paramsBuffer.array();
    }
}

