/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import no.nordicsemi.android.mesh.ApplicationKey;
import no.nordicsemi.android.mesh.logger.MeshLogger;
import no.nordicsemi.android.mesh.transport.ApplicationMessage;
import no.nordicsemi.android.mesh.utils.SecureUtils;

public class LightLightnessSet
extends ApplicationMessage {
    private static final String TAG = LightLightnessSet.class.getSimpleName();
    private static final int OP_CODE = 33356;
    private static final int LIGHT_LIGHTNESS_SET_TRANSITION_PARAMS_LENGTH = 5;
    private static final int LIGHT_LIGHTNESS_SET_PARAMS_LENGTH = 3;
    private final Integer mTransitionSteps;
    private final Integer mTransitionResolution;
    private final Integer mDelay;
    private final int mLightness;
    private final int tId;

    public LightLightnessSet(@NonNull ApplicationKey appKey, int lightLightness, int tId) throws IllegalArgumentException {
        this(appKey, null, null, null, lightLightness, tId);
    }

    public LightLightnessSet(@NonNull ApplicationKey appKey, @Nullable Integer transitionSteps, @Nullable Integer transitionResolution, @Nullable Integer delay, int lightLightness, int tId) throws IllegalArgumentException {
        super(appKey);
        this.mTransitionSteps = transitionSteps;
        this.mTransitionResolution = transitionResolution;
        this.mDelay = delay;
        this.tId = tId;
        if (lightLightness < 0 || lightLightness > 65535) {
            throw new IllegalArgumentException("Light lightness value must be between 0x0000 and 0xFFFF");
        }
        this.mLightness = lightLightness;
        this.assembleMessageParameters();
    }

    @Override
    public int getOpCode() {
        return 33356;
    }

    @Override
    void assembleMessageParameters() {
        ByteBuffer paramsBuffer;
        this.mAid = SecureUtils.calculateK4(this.mAppKey.getKey());
        MeshLogger.verbose(TAG, "Lightness: " + this.mLightness);
        if (this.mTransitionSteps == null || this.mTransitionResolution == null || this.mDelay == null) {
            paramsBuffer = ByteBuffer.allocate(3).order(ByteOrder.LITTLE_ENDIAN);
            paramsBuffer.putShort((short)this.mLightness);
            paramsBuffer.put((byte)this.tId);
        } else {
            MeshLogger.verbose(TAG, "Transition steps: " + this.mTransitionSteps);
            MeshLogger.verbose(TAG, "Transition step resolution: " + this.mTransitionResolution);
            paramsBuffer = ByteBuffer.allocate(5).order(ByteOrder.LITTLE_ENDIAN);
            paramsBuffer.putShort((short)this.mLightness);
            paramsBuffer.put((byte)this.tId);
            paramsBuffer.put((byte)(this.mTransitionResolution << 6 | this.mTransitionSteps));
            int delay = this.mDelay;
            paramsBuffer.put((byte)delay);
        }
        this.mParameters = paramsBuffer.array();
    }
}

