/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.util.SparseArray;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import no.nordicsemi.android.mesh.control.BlockAcknowledgementMessage;
import no.nordicsemi.android.mesh.logger.MeshLogger;
import no.nordicsemi.android.mesh.transport.AccessMessage;
import no.nordicsemi.android.mesh.transport.ControlMessage;
import no.nordicsemi.android.mesh.transport.LowerTransportLayerCallbacks;
import no.nordicsemi.android.mesh.transport.Message;
import no.nordicsemi.android.mesh.transport.UpperTransportLayer;
import no.nordicsemi.android.mesh.utils.ExtendedInvalidCipherTextException;
import no.nordicsemi.android.mesh.utils.MeshAddress;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;

abstract class LowerTransportLayer
extends UpperTransportLayer {
    private static final String TAG = LowerTransportLayer.class.getSimpleName();
    private static final int BLOCK_ACK_TIMER = 150;
    private static final int UNSEGMENTED_HEADER = 0;
    private static final int SEGMENTED_HEADER = 1;
    private static final int UNSEGMENTED_MESSAGE_HEADER_LENGTH = 1;
    private static final int SEGMENTED_MESSAGE_HEADER_LENGTH = 4;
    private static final int UNSEGMENTED_ACK_MESSAGE_HEADER_LENGTH = 3;
    private static final long INCOMPLETE_TIMER_DELAY = 10000L;
    private final SparseArray<byte[]> segmentedAccessMessageMap = new SparseArray();
    private final SparseArray<byte[]> segmentedControlMessageMap = new SparseArray();
    LowerTransportLayerCallbacks mLowerTransportLayerCallbacks;
    private boolean mSegmentedAccessAcknowledgementTimerStarted;
    private Integer mSegmentedAccessBlockAck;
    private boolean mSegmentedControlAcknowledgementTimerStarted;
    private Integer mSegmentedControlBlockAck;
    private boolean mIncompleteTimerStarted;
    private boolean mBlockAckSent;
    private long mDuration;
    private final Runnable mIncompleteTimerRunnable = new Runnable(){

        @Override
        public void run() {
            LowerTransportLayer.this.mLowerTransportLayerCallbacks.onIncompleteTimerExpired();
            LowerTransportLayer.this.mIncompleteTimerStarted = false;
        }
    };

    LowerTransportLayer() {
    }

    abstract void setLowerTransportLayerCallbacks(@NonNull LowerTransportLayerCallbacks var1);

    protected abstract Message createNetworkLayerPDU(@NonNull Message var1);

    @Override
    void createMeshMessage(@NonNull Message message) {
        super.createMeshMessage(message);
        if (message instanceof AccessMessage) {
            this.createLowerTransportAccessPDU((AccessMessage)message);
        } else {
            this.createLowerTransportControlPDU((ControlMessage)message);
        }
    }

    @Override
    void createVendorMeshMessage(@NonNull Message message) {
        if (message instanceof AccessMessage) {
            super.createVendorMeshMessage(message);
            this.createLowerTransportAccessPDU((AccessMessage)message);
        } else {
            this.createLowerTransportControlPDU((ControlMessage)message);
        }
    }

    @Override
    @VisibleForTesting(otherwise=4)
    public final void createLowerTransportAccessPDU(@NonNull AccessMessage message) {
        SparseArray lowerTransportAccessPduMap;
        byte[] upperTransportPDU = message.getUpperTransportPdu();
        if (upperTransportPDU.length <= 12) {
            message.setSegmented(false);
            byte[] lowerTransportPDU = this.createUnsegmentedAccessMessage(message);
            lowerTransportAccessPduMap = new SparseArray();
            lowerTransportAccessPduMap.put(0, (Object)lowerTransportPDU);
        } else {
            message.setSegmented(true);
            lowerTransportAccessPduMap = this.createSegmentedAccessMessage(message);
        }
        message.setLowerTransportAccessPdu(lowerTransportAccessPduMap);
    }

    @Override
    @VisibleForTesting(otherwise=4)
    public final void createLowerTransportControlPDU(@NonNull ControlMessage message) {
        switch (message.getPduType()) {
            case 2: {
                SparseArray lowerTransportControlPduArray = new SparseArray();
                lowerTransportControlPduArray.put(0, (Object)message.getTransportControlPdu());
                message.setLowerTransportControlPdu((SparseArray<byte[]>)lowerTransportControlPduArray);
                break;
            }
            case 0: {
                byte[] transportControlPdu = message.getTransportControlPdu();
                if (transportControlPdu.length <= 11) {
                    MeshLogger.verbose(TAG, "Creating unsegmented transport control");
                    this.createUnsegmentedControlMessage(message);
                    break;
                }
                MeshLogger.verbose(TAG, "Creating segmented transport control");
                this.createSegmentedControlMessage(message);
            }
        }
    }

    @Override
    final void reassembleLowerTransportAccessPDU(@NonNull AccessMessage accessMessage) {
        SparseArray<byte[]> lowerTransportAccessPdu = this.removeLowerTransportAccessMessageHeader(accessMessage);
        byte[] upperTransportPdu = MeshParserUtils.concatenateSegmentedMessages(lowerTransportAccessPdu);
        accessMessage.setUpperTransportPdu(upperTransportPdu);
    }

    @Override
    final void reassembleLowerTransportControlPDU(@NonNull ControlMessage controlMessage) {
        SparseArray<byte[]> lowerTransportPdu = this.removeLowerTransportControlMessageHeader(controlMessage);
        byte[] lowerTransportControlPdu = MeshParserUtils.concatenateSegmentedMessages(lowerTransportPdu);
        controlMessage.setTransportControlPdu(lowerTransportControlPdu);
    }

    private SparseArray<byte[]> removeLowerTransportAccessMessageHeader(@NonNull AccessMessage message) {
        SparseArray<byte[]> messages = message.getLowerTransportAccessPdu();
        if (message.isSegmented()) {
            for (int i = 0; i < messages.size(); ++i) {
                byte[] data = (byte[])messages.get(i);
                int length = data.length - 4;
                messages.put(i, (Object)this.removeHeader(data, 4, length));
            }
        } else {
            byte[] data = (byte[])messages.get(0);
            int length = data.length - 1;
            messages.put(0, (Object)this.removeHeader(data, 1, length));
        }
        return messages;
    }

    private SparseArray<byte[]> removeLowerTransportControlMessageHeader(@NonNull ControlMessage message) {
        SparseArray<byte[]> messages = message.getLowerTransportControlPdu();
        if (messages.size() > 1) {
            for (int i = 0; i < messages.size(); ++i) {
                byte[] data = (byte[])messages.get(i);
                int length = data.length - 4;
                messages.put(i, (Object)this.removeHeader(data, 4, length));
            }
        } else {
            int opCode = message.getOpCode();
            if (opCode == 0) {
                byte[] data = (byte[])messages.get(0);
                int length = data.length - 3;
                messages.put(0, (Object)this.removeHeader(data, 3, length));
            } else {
                byte[] data = (byte[])messages.get(0);
                int length = data.length - 1;
                messages.put(0, (Object)this.removeHeader(data, 1, length));
            }
        }
        return messages;
    }

    private byte[] removeHeader(@NonNull byte[] data, int offset, int length) {
        ByteBuffer buffer = ByteBuffer.allocate(length).order(ByteOrder.BIG_ENDIAN);
        buffer.put(data, offset, length);
        return buffer.array();
    }

    private byte[] createUnsegmentedAccessMessage(@NonNull AccessMessage message) {
        byte[] encryptedUpperTransportPDU = message.getUpperTransportPdu();
        int seg = message.isSegmented() ? 1 : 0;
        int akfAid = message.getAkf() << 6 | message.getAid();
        byte header = (byte)(seg << 7 | akfAid);
        ByteBuffer lowerTransportBuffer = ByteBuffer.allocate(1 + encryptedUpperTransportPDU.length).order(ByteOrder.BIG_ENDIAN);
        lowerTransportBuffer.put(header);
        lowerTransportBuffer.put(encryptedUpperTransportPDU);
        byte[] lowerTransportPDU = lowerTransportBuffer.array();
        MeshLogger.verbose(TAG, "Unsegmented Lower transport access PDU " + MeshParserUtils.bytesToHex(lowerTransportPDU, false));
        return lowerTransportPDU;
    }

    private SparseArray<byte[]> createSegmentedAccessMessage(@NonNull AccessMessage message) {
        byte[] encryptedUpperTransportPDU = message.getUpperTransportPdu();
        int akfAid = message.getAkf() << 6 | message.getAid();
        int aszmic = message.getAszmic();
        byte[] sequenceNumber = message.getSequenceNumber();
        int seqZero = MeshParserUtils.calculateSeqZero(sequenceNumber);
        int numberOfSegments = (encryptedUpperTransportPDU.length + 11) / 12;
        int segN = numberOfSegments - 1;
        SparseArray lowerTransportPduMap = new SparseArray();
        int offset = 0;
        for (int segO = 0; segO < numberOfSegments; ++segO) {
            int length = Math.min(encryptedUpperTransportPDU.length - offset, 12);
            ByteBuffer lowerTransportBuffer = ByteBuffer.allocate(4 + length).order(ByteOrder.BIG_ENDIAN);
            lowerTransportBuffer.put((byte)(0x80 | akfAid));
            lowerTransportBuffer.put((byte)(aszmic << 7 | seqZero >> 6 & 0x7F));
            lowerTransportBuffer.put((byte)(seqZero << 2 & 0xFC | segO >> 3 & 3));
            lowerTransportBuffer.put((byte)(segO << 5 & 0xE0 | segN & 0x1F));
            lowerTransportBuffer.put(encryptedUpperTransportPDU, offset, length);
            offset += length;
            byte[] lowerTransportPDU = lowerTransportBuffer.array();
            MeshLogger.verbose(TAG, "Segmented Lower transport access PDU: " + MeshParserUtils.bytesToHex(lowerTransportPDU, false) + " " + segO + " of " + numberOfSegments);
            lowerTransportPduMap.put(segO, (Object)lowerTransportPDU);
        }
        return lowerTransportPduMap;
    }

    @VisibleForTesting(otherwise=4)
    private void createUnsegmentedControlMessage(@NonNull ControlMessage message) {
        ByteBuffer lowerTransportBuffer;
        message.setSegmented(false);
        int opCode = message.getOpCode();
        byte[] parameters = message.getParameters();
        byte[] upperTransportControlPDU = message.getTransportControlPdu();
        byte header = (byte)(0 | opCode);
        if (parameters != null) {
            int pduLength = 1 + parameters.length + upperTransportControlPDU.length;
            lowerTransportBuffer = ByteBuffer.allocate(pduLength).order(ByteOrder.BIG_ENDIAN);
            lowerTransportBuffer.put(header);
            lowerTransportBuffer.put(parameters);
        } else {
            int pduLength = 1 + upperTransportControlPDU.length;
            lowerTransportBuffer = ByteBuffer.allocate(pduLength).order(ByteOrder.BIG_ENDIAN);
            lowerTransportBuffer.put(header);
        }
        lowerTransportBuffer.put(upperTransportControlPDU);
        byte[] lowerTransportPDU = lowerTransportBuffer.array();
        MeshLogger.verbose(TAG, "Unsegmented Lower transport control PDU " + MeshParserUtils.bytesToHex(lowerTransportPDU, false));
        SparseArray lowerTransportControlPduMap = new SparseArray();
        lowerTransportControlPduMap.put(0, (Object)lowerTransportPDU);
        message.setLowerTransportControlPdu((SparseArray<byte[]>)lowerTransportControlPduMap);
    }

    private void createSegmentedControlMessage(@NonNull ControlMessage controlMessage) {
        controlMessage.setSegmented(false);
        byte[] encryptedUpperTransportControlPDU = controlMessage.getTransportControlPdu();
        int opCode = controlMessage.getOpCode();
        boolean rfu = false;
        byte[] sequenceNumber = controlMessage.getSequenceNumber();
        int seqZero = MeshParserUtils.calculateSeqZero(sequenceNumber);
        int numberOfSegments = (encryptedUpperTransportControlPDU.length + 7) / 8;
        int segN = numberOfSegments - 1;
        SparseArray lowerTransportControlPduMap = new SparseArray();
        int offset = 0;
        for (int segO = 0; segO < numberOfSegments; ++segO) {
            int length = Math.min(encryptedUpperTransportControlPDU.length - offset, 8);
            ByteBuffer lowerTransportBuffer = ByteBuffer.allocate(4 + length).order(ByteOrder.BIG_ENDIAN);
            lowerTransportBuffer.put((byte)(0x80 | opCode));
            lowerTransportBuffer.put((byte)(0 | seqZero >> 6 & 0x7F));
            lowerTransportBuffer.put((byte)(seqZero << 2 & 0xFC | segO >> 3 & 3));
            lowerTransportBuffer.put((byte)(segO << 5 & 0xE0 | segN & 0x1F));
            lowerTransportBuffer.put(encryptedUpperTransportControlPDU, offset, length);
            offset += length;
            byte[] lowerTransportPDU = lowerTransportBuffer.array();
            MeshLogger.verbose(TAG, "Segmented Lower transport access PDU: " + MeshParserUtils.bytesToHex(lowerTransportPDU, false) + " " + segO + " of " + numberOfSegments);
            lowerTransportControlPduMap.put(segO, (Object)lowerTransportPDU);
        }
        controlMessage.setLowerTransportControlPdu((SparseArray<byte[]>)lowerTransportControlPduMap);
    }

    final boolean isSegmentedMessage(byte lowerTransportHeader) {
        return (lowerTransportHeader >> 7 & 1) == 1;
    }

    final AccessMessage parseUnsegmentedAccessLowerTransportPDU(@NonNull byte[] pdu, int ivIndex, @NonNull byte[] sequenceNumber) {
        AccessMessage message = null;
        byte header = pdu[10];
        int seg = header >> 7 & 1;
        int akf = header >> 6 & 1;
        int aid = header & 0x3F;
        if (seg == 0) {
            MeshLogger.debug(TAG, "IV Index of received message: " + ivIndex);
            int seqAuth = ivIndex << 24 | MeshParserUtils.convert24BitsToInt(sequenceNumber);
            byte[] src = MeshParserUtils.getSrcAddress(pdu);
            int srcAdd = MeshParserUtils.unsignedBytesToInt(src[1], src[0]);
            MeshLogger.debug(TAG, "SeqAuth: " + seqAuth);
            if (!this.isValidSeqAuth(seqAuth, srcAdd)) {
                return null;
            }
            this.mMeshNode.setSeqAuth(srcAdd, seqAuth);
            message = new AccessMessage();
            if (akf == 0) {
                int lowerTransportPduLength = pdu.length - 10;
                ByteBuffer lowerTransportBuffer = ByteBuffer.allocate(lowerTransportPduLength).order(ByteOrder.BIG_ENDIAN);
                lowerTransportBuffer.put(pdu, 10, lowerTransportPduLength);
                byte[] lowerTransportPDU = lowerTransportBuffer.array();
                SparseArray messages = new SparseArray();
                messages.put(0, (Object)lowerTransportPDU);
                message.setSegmented(false);
                message.setAszmic(0);
                message.setAkf(akf);
                message.setAid(aid);
                message.setLowerTransportAccessPdu((SparseArray<byte[]>)messages);
            } else {
                int lowerTransportPduLength = pdu.length - 10;
                ByteBuffer lowerTransportBuffer = ByteBuffer.allocate(lowerTransportPduLength).order(ByteOrder.BIG_ENDIAN);
                lowerTransportBuffer.put(pdu, 10, lowerTransportPduLength);
                byte[] lowerTransportPDU = lowerTransportBuffer.array();
                SparseArray messages = new SparseArray();
                messages.put(0, (Object)lowerTransportPDU);
                message.setSegmented(false);
                message.setAszmic(0);
                message.setAkf(akf);
                message.setAid(aid);
                message.setLowerTransportAccessPdu((SparseArray<byte[]>)messages);
            }
        }
        return message;
    }

    /*
     * Enabled aggressive block sorting
     */
    final AccessMessage parseSegmentedAccessLowerTransportPDU(int ttl, @NonNull byte[] pdu, int ivIndex, @NonNull byte[] sequenceNumber) {
        byte header = pdu[10];
        int akf = header >> 6 & 1;
        int aid = header & 0x3F;
        int szmic = pdu[11] >> 7 & 1;
        int seqZero = (pdu[11] & 0x7F) << 6 | (pdu[12] & 0xFC) >> 2;
        int segO = (pdu[12] & 3) << 3 | (pdu[13] & 0xE0) >> 5;
        int segN = pdu[13] & 0x1F;
        byte[] src = MeshParserUtils.getSrcAddress(pdu);
        byte[] dst = MeshParserUtils.getDstAddress(pdu);
        int blockAckSrc = MeshParserUtils.unsignedBytesToInt(dst[1], dst[0]);
        int blockAckDst = MeshParserUtils.unsignedBytesToInt(src[1], src[0]);
        MeshLogger.verbose(TAG, "SEG O: " + segO);
        MeshLogger.verbose(TAG, "SEG N: " + segN);
        int seqNumber = this.getTransportLayerSequenceNumber(MeshParserUtils.convert24BitsToInt(sequenceNumber), seqZero);
        int seqAuth = ivIndex << 24 | seqNumber;
        Integer lastSeqAuth = this.mMeshNode.getSeqAuth(blockAckDst);
        if (lastSeqAuth != null) {
            MeshLogger.verbose(TAG, "Last SeqAuth value " + lastSeqAuth);
        }
        MeshLogger.verbose(TAG, "Current SeqAuth value " + seqAuth);
        int payloadLength = pdu.length - 10;
        ByteBuffer payloadBuffer = ByteBuffer.allocate(payloadLength);
        payloadBuffer.put(pdu, 10, payloadLength);
        if (lastSeqAuth == null || lastSeqAuth < seqAuth) {
            this.segmentedAccessMessageMap.clear();
            this.segmentedAccessMessageMap.put(segO, (Object)payloadBuffer.array());
            this.mMeshNode.setSeqAuth(blockAckDst, seqAuth);
            MeshLogger.verbose(TAG, "Starting incomplete timer for src: " + MeshAddress.formatAddress(blockAckDst, false));
            this.initIncompleteTimer();
            if (!MeshAddress.isValidUnicastAddress(dst)) return null;
            this.mSegmentedAccessBlockAck = BlockAcknowledgementMessage.calculateBlockAcknowledgement(null, segO);
            this.initSegmentedAccessAcknowledgementTimer(seqZero, ttl, blockAckSrc, blockAckDst, segN);
            return null;
        }
        if (lastSeqAuth != seqAuth) return null;
        if (!this.mIncompleteTimerStarted) {
            MeshLogger.verbose(TAG, "Ignoring message since the incomplete timer has expired and all messages have been received");
            return null;
        }
        if (this.segmentedAccessMessageMap.get(segO) == null) {
            this.segmentedAccessMessageMap.put(segO, (Object)payloadBuffer.array());
        }
        int receivedSegmentedMessageCount = this.segmentedAccessMessageMap.size();
        MeshLogger.verbose(TAG, "Received segment message count: " + receivedSegmentedMessageCount);
        if (receivedSegmentedMessageCount != segN + 1) {
            this.restartIncompleteTimer();
            this.mSegmentedAccessBlockAck = BlockAcknowledgementMessage.calculateBlockAcknowledgement(this.mSegmentedAccessBlockAck, segO);
            MeshLogger.verbose(TAG, "Restarting incomplete timer for src: " + MeshAddress.formatAddress(blockAckDst, false));
            if (!MeshAddress.isValidUnicastAddress(dst)) return null;
            if (this.mSegmentedAccessAcknowledgementTimerStarted) return null;
            MeshLogger.verbose(TAG, "Restarting block acknowledgement timer for src: " + MeshAddress.formatAddress(blockAckDst, false));
            this.initSegmentedAccessAcknowledgementTimer(seqZero, ttl, blockAckSrc, blockAckDst, segN);
            return null;
        }
        if (MeshAddress.isValidUnicastAddress(dst)) {
            this.mSegmentedAccessBlockAck = BlockAcknowledgementMessage.calculateBlockAcknowledgement(this.mSegmentedAccessBlockAck, segO);
            this.handleImmediateBlockAcks(seqZero, ttl, blockAckSrc, blockAckDst, segN);
        } else {
            this.cancelIncompleteTimer();
        }
        AccessMessage accessMessage = new AccessMessage();
        accessMessage.setAszmic(szmic);
        accessMessage.setSequenceNumber(MeshParserUtils.getSequenceNumberBytes(seqNumber));
        accessMessage.setAkf(akf);
        accessMessage.setAid(aid);
        accessMessage.setSegmented(true);
        SparseArray segmentedMessages = this.segmentedAccessMessageMap.clone();
        accessMessage.setLowerTransportAccessPdu((SparseArray<byte[]>)segmentedMessages);
        return accessMessage;
    }

    private void handleImmediateBlockAcks(int seqZero, int ttl, int src, int dst, int segN) {
        this.cancelIncompleteTimer();
        this.sendBlockAck(seqZero, ttl, src, dst, segN);
    }

    final void parseUnsegmentedControlLowerTransportPDU(@NonNull ControlMessage controlMessage, @NonNull byte[] decryptedProxyPdu) throws ExtendedInvalidCipherTextException {
        SparseArray unsegmentedMessages = new SparseArray();
        int lowerTransportPduLength = decryptedProxyPdu.length - 10;
        ByteBuffer lowerTransportBuffer = ByteBuffer.allocate(lowerTransportPduLength).order(ByteOrder.BIG_ENDIAN);
        lowerTransportBuffer.put(decryptedProxyPdu, 10, lowerTransportPduLength);
        byte[] lowerTransportPDU = lowerTransportBuffer.array();
        unsegmentedMessages.put(0, (Object)lowerTransportPDU);
        byte pduType = decryptedProxyPdu[0];
        switch (pduType) {
            case 0: {
                byte header = decryptedProxyPdu[10];
                int opCode = header & 0x7F;
                controlMessage.setPduType(0);
                controlMessage.setAszmic(0);
                controlMessage.setOpCode(opCode);
                controlMessage.setLowerTransportControlPdu((SparseArray<byte[]>)unsegmentedMessages);
                this.parseLowerTransportLayerPDU(controlMessage);
                break;
            }
            case 2: {
                controlMessage.setPduType(2);
                controlMessage.setLowerTransportControlPdu((SparseArray<byte[]>)unsegmentedMessages);
                this.parseUpperTransportPDU(controlMessage);
            }
        }
    }

    final ControlMessage parseSegmentedControlLowerTransportPDU(@NonNull byte[] pdu) {
        byte header = pdu[10];
        int akf = header >> 6 & 1;
        int aid = header & 0x3F;
        int szmic = pdu[11] >> 7 & 1;
        int seqZero = (pdu[11] & 0x7F) << 6 | (pdu[12] & 0xFC) >> 2;
        int segO = (pdu[12] & 3) << 3 | (pdu[13] & 0xE0) >> 5;
        int segN = pdu[13] & 0x1F;
        int ttl = pdu[2] & 0x7F;
        byte[] src = MeshParserUtils.getSrcAddress(pdu);
        byte[] dst = MeshParserUtils.getDstAddress(pdu);
        int blockAckSrc = MeshParserUtils.unsignedBytesToInt(dst[1], dst[0]);
        int blockAckDst = MeshParserUtils.unsignedBytesToInt(src[1], src[0]);
        MeshLogger.verbose(TAG, "SEG O: " + segO);
        MeshLogger.verbose(TAG, "SEG N: " + segN);
        this.initSegmentedControlAcknowledgementTimer(seqZero, ttl, blockAckDst, blockAckSrc, segN);
        this.mSegmentedControlBlockAck = BlockAcknowledgementMessage.calculateBlockAcknowledgement(this.mSegmentedControlBlockAck, segO);
        MeshLogger.verbose(TAG, "Block acknowledgement value for " + this.mSegmentedControlBlockAck + " Seg O " + segO);
        int payloadLength = pdu.length - 10;
        ByteBuffer payloadBuffer = ByteBuffer.allocate(payloadLength);
        payloadBuffer.put(pdu, 10, payloadLength);
        this.segmentedControlMessageMap.put(segO, (Object)payloadBuffer.array());
        int receivedSegmentedMessageCount = this.segmentedControlMessageMap.size() - 1;
        if (segN == receivedSegmentedMessageCount) {
            MeshLogger.verbose(TAG, "All segments received");
            this.mHandler.removeCallbacks(this.mIncompleteTimerRunnable);
            MeshLogger.verbose(TAG, "Block ack sent? " + this.mBlockAckSent);
            if (this.mDuration > System.currentTimeMillis() && !this.mBlockAckSent && MeshAddress.isValidUnicastAddress(dst)) {
                this.mHandler.removeCallbacksAndMessages(null);
                MeshLogger.verbose(TAG, "Cancelling Scheduled block ack and incomplete timer, sending an immediate block ack");
                this.sendBlockAck(seqZero, ttl, blockAckSrc, blockAckDst, segN);
            }
            int upperTransportSequenceNumber = this.getTransportLayerSequenceNumber(MeshParserUtils.getSequenceNumberFromPDU(pdu), seqZero);
            byte[] sequenceNumber = MeshParserUtils.getSequenceNumberBytes(upperTransportSequenceNumber);
            ControlMessage message = new ControlMessage();
            message.setAszmic(szmic);
            message.setSequenceNumber(sequenceNumber);
            message.setAkf(akf);
            message.setAid(aid);
            message.setSegmented(true);
            SparseArray segmentedMessages = this.segmentedControlMessageMap.clone();
            this.segmentedControlMessageMap.clear();
            message.setLowerTransportControlPdu((SparseArray<byte[]>)segmentedMessages);
            return message;
        }
        return null;
    }

    private void initIncompleteTimer() {
        this.mHandler.postDelayed(this.mIncompleteTimerRunnable, 10000L);
        this.mIncompleteTimerStarted = true;
    }

    private void restartIncompleteTimer() {
        if (this.mIncompleteTimerStarted) {
            this.mHandler.removeCallbacks(this.mIncompleteTimerRunnable);
        }
        this.initIncompleteTimer();
    }

    private void cancelIncompleteTimer() {
        this.mIncompleteTimerStarted = false;
        this.mHandler.removeCallbacks(this.mIncompleteTimerRunnable);
    }

    private void initSegmentedAccessAcknowledgementTimer(int seqZero, int ttl, int src, int dst, int segN) {
        if (!this.mSegmentedAccessAcknowledgementTimerStarted) {
            this.mSegmentedAccessAcknowledgementTimerStarted = true;
            MeshLogger.verbose(TAG, "TTL: " + ttl);
            int duration = 150 + 50 * ttl;
            MeshLogger.verbose(TAG, "Duration: " + duration);
            this.mDuration = System.currentTimeMillis() + (long)duration;
            this.mHandler.postDelayed(() -> {
                MeshLogger.verbose(TAG, "Acknowledgement timer expiring");
                this.sendBlockAck(seqZero, ttl, src, dst, segN);
            }, (long)duration);
        }
    }

    private void initSegmentedControlAcknowledgementTimer(int seqZero, int ttl, int src, int dst, int segN) {
        if (!this.mSegmentedControlAcknowledgementTimerStarted) {
            this.mSegmentedControlAcknowledgementTimerStarted = true;
            int duration = 150 + 50 * ttl;
            this.mDuration = System.currentTimeMillis() + (long)duration;
            this.mHandler.postDelayed(() -> this.sendBlockAck(seqZero, ttl, src, dst, segN), (long)duration);
        }
    }

    private void sendBlockAck(int seqZero, int ttl, int src, int dst, int segN) {
        int blockAck = this.mSegmentedAccessBlockAck;
        if (BlockAcknowledgementMessage.hasAllSegmentsBeenReceived(blockAck, segN)) {
            MeshLogger.verbose(TAG, "All segments received cancelling incomplete timer");
            this.cancelIncompleteTimer();
        }
        byte[] upperTransportControlPdu = this.createAcknowledgementPayload(seqZero, blockAck);
        MeshLogger.verbose(TAG, "Block acknowledgement payload: " + MeshParserUtils.bytesToHex(upperTransportControlPdu, false));
        ControlMessage controlMessage = new ControlMessage();
        controlMessage.setOpCode(0);
        controlMessage.setTransportControlPdu(upperTransportControlPdu);
        controlMessage.setTtl(ttl);
        controlMessage.setPduType(0);
        controlMessage.setSrc(src);
        controlMessage.setDst(dst);
        controlMessage.setIvIndex(this.mUpperTransportLayerCallbacks.getIvIndex());
        int sequenceNumber = this.mUpperTransportLayerCallbacks.getNode(controlMessage.getSrc()).incrementSequenceNumber();
        byte[] sequenceNum = MeshParserUtils.getSequenceNumberBytes(sequenceNumber);
        controlMessage.setSequenceNumber(sequenceNum);
        this.mBlockAckSent = true;
        this.mLowerTransportLayerCallbacks.sendSegmentAcknowledgementMessage(controlMessage);
        this.mSegmentedAccessAcknowledgementTimerStarted = false;
    }

    private byte[] createAcknowledgementPayload(int seqZero, int blockAcknowledgement) {
        boolean obo = false;
        boolean rfu = false;
        ByteBuffer buffer = ByteBuffer.allocate(6).order(ByteOrder.BIG_ENDIAN);
        buffer.put((byte)(0 | seqZero >> 6 & 0x7F));
        buffer.put((byte)(seqZero << 2 & 0xFC | 0));
        buffer.putInt(blockAcknowledgement);
        return buffer.array();
    }

    private void parseLowerTransportLayerPDU(@NonNull ControlMessage controlMessage) {
        this.reassembleLowerTransportControlPDU(controlMessage);
        byte[] transportControlPdu = controlMessage.getTransportControlPdu();
        int opCode = controlMessage.getOpCode();
        if (opCode == 0) {
            BlockAcknowledgementMessage acknowledgement = new BlockAcknowledgementMessage(transportControlPdu);
            controlMessage.setTransportControlMessage(acknowledgement);
        }
    }

    private boolean isValidSeqAuth(int seqAuth, int src) {
        Integer lastSeqAuth = this.mMeshNode.getSeqAuth(src);
        return lastSeqAuth == null || lastSeqAuth < seqAuth;
    }
}

