/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.List;
import no.nordicsemi.android.mesh.InternalTransportCallbacks;
import no.nordicsemi.android.mesh.MeshStatusCallbacks;
import no.nordicsemi.android.mesh.logger.MeshLogger;
import no.nordicsemi.android.mesh.transport.ControlMessage;
import no.nordicsemi.android.mesh.transport.InternalMeshMsgHandlerCallbacks;
import no.nordicsemi.android.mesh.transport.LowerTransportLayerCallbacks;
import no.nordicsemi.android.mesh.transport.MeshMessage;
import no.nordicsemi.android.mesh.transport.MeshTransport;
import no.nordicsemi.android.mesh.transport.Message;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;

abstract class MeshMessageState
implements LowerTransportLayerCallbacks {
    private static final String TAG = MeshMessageState.class.getSimpleName();
    MeshMessage mMeshMessage;
    final MeshTransport mMeshTransport;
    private final InternalMeshMsgHandlerCallbacks meshMessageHandlerCallbacks;
    protected InternalTransportCallbacks mInternalTransportCallbacks;
    MeshStatusCallbacks mMeshStatusCallbacks;
    int mSrc;
    int mDst;
    protected Message message;

    MeshMessageState(@Nullable MeshMessage meshMessage, @NonNull MeshTransport meshTransport, @NonNull InternalMeshMsgHandlerCallbacks handlerCallbacks, @NonNull InternalTransportCallbacks transportCallbacks, @NonNull MeshStatusCallbacks statusCallbacks) {
        this.mMeshMessage = meshMessage;
        if (meshMessage != null) {
            this.message = meshMessage.getMessage();
        }
        this.meshMessageHandlerCallbacks = handlerCallbacks;
        this.mInternalTransportCallbacks = transportCallbacks;
        this.mMeshStatusCallbacks = statusCallbacks;
        this.mMeshTransport = meshTransport;
        this.mMeshTransport.setLowerTransportLayerCallbacks(this);
    }

    abstract MessageState getState();

    MeshTransport getMeshTransport() {
        return this.mMeshTransport;
    }

    public MeshMessage getMeshMessage() {
        return this.mMeshMessage;
    }

    public void executeSend() {
        if (this.message.getNetworkLayerPdu().size() > 0) {
            for (int i = 0; i < this.message.getNetworkLayerPdu().size(); ++i) {
                this.mInternalTransportCallbacks.onMeshPduCreated(this.mDst, (byte[])this.message.getNetworkLayerPdu().get(i));
            }
            if (this.mMeshStatusCallbacks != null) {
                this.mMeshStatusCallbacks.onMeshMessageProcessed(this.mDst, this.mMeshMessage);
            }
        }
    }

    final void executeResend(List<Integer> retransmitPduIndexes) {
        if (this.message.getNetworkLayerPdu().size() > 0 && !retransmitPduIndexes.isEmpty()) {
            for (int i = 0; i < retransmitPduIndexes.size(); ++i) {
                int segO = retransmitPduIndexes.get(i);
                if (this.message.getNetworkLayerPdu().get(segO) == null) continue;
                byte[] pdu = (byte[])this.message.getNetworkLayerPdu().get(segO);
                MeshLogger.verbose(TAG, "Resending segment " + segO + " : " + MeshParserUtils.bytesToHex(pdu, false));
                Message retransmitMeshMessage = this.mMeshTransport.createRetransmitMeshMessage(this.message, segO);
                this.mInternalTransportCallbacks.onMeshPduCreated(this.mDst, (byte[])retransmitMeshMessage.getNetworkLayerPdu().get(segO));
            }
        }
    }

    @Override
    public void onIncompleteTimerExpired() {
        MeshLogger.verbose(TAG, "Incomplete timer has expired, all segments were not received!");
        if (this.meshMessageHandlerCallbacks != null) {
            this.meshMessageHandlerCallbacks.onIncompleteTimerExpired(this.mDst);
            if (this.mMeshStatusCallbacks != null) {
                this.mMeshStatusCallbacks.onTransactionFailed(this.mDst, true);
            }
        }
    }

    @Override
    public int getTtl() {
        return this.message.getTtl();
    }

    @Override
    public void sendSegmentAcknowledgementMessage(ControlMessage controlMessage) {
        ControlMessage message = this.mMeshTransport.createSegmentBlockAcknowledgementMessage(controlMessage);
        MeshLogger.verbose(TAG, "Sending acknowledgement: " + MeshParserUtils.bytesToHex((byte[])message.getNetworkLayerPdu().get(0), false));
        this.mInternalTransportCallbacks.onMeshPduCreated(message.getDst(), (byte[])message.getNetworkLayerPdu().get(0));
        this.mMeshStatusCallbacks.onBlockAcknowledgementProcessed(message.getDst(), controlMessage);
    }

    public static enum MessageState {
        PROXY_CONFIG_MESSAGE_STATE(500),
        CONFIG_MESSAGE_STATE(501),
        APPLICATION_MESSAGE_STATE(502),
        VENDOR_MODEL_ACKNOWLEDGED_STATE(1000),
        VENDOR_MODEL_UNACKNOWLEDGED_STATE(1001);

        private int state;

        private MessageState(int state) {
            this.state = state;
        }

        public int getState() {
            return this.state;
        }
    }
}

