/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import no.nordicsemi.android.mesh.AllocatedGroupRange;
import no.nordicsemi.android.mesh.logger.MeshLogger;

final class AllocatedGroupRangeDbMigrator
implements JsonDeserializer<List<AllocatedGroupRange>> {
    private static final String TAG = AllocatedGroupRangeDbMigrator.class.getSimpleName();

    AllocatedGroupRangeDbMigrator() {
    }

    public List<AllocatedGroupRange> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        ArrayList<AllocatedGroupRange> groupRanges = new ArrayList<AllocatedGroupRange>();
        try {
            if (json.isJsonArray()) {
                JsonArray jsonObject = json.getAsJsonArray();
                for (int i = 0; i < jsonObject.size(); ++i) {
                    JsonObject unicastRangeJson = jsonObject.get(i).getAsJsonObject();
                    int lowAddress = unicastRangeJson.get("lowAddress").getAsInt();
                    int highAddress = unicastRangeJson.get("highAddress").getAsInt();
                    groupRanges.add(new AllocatedGroupRange(lowAddress, highAddress));
                }
            }
        }
        catch (Exception ex) {
            MeshLogger.error(TAG, "Error while de-serializing Allocated group range: " + ex.getMessage());
        }
        return groupRanges;
    }
}

