/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh;

import androidx.annotation.NonNull;
import com.google.gson.annotations.Expose;
import java.util.ArrayList;
import java.util.List;
import no.nordicsemi.android.mesh.AllocatedGroupRange;
import no.nordicsemi.android.mesh.AllocatedUnicastRange;
import no.nordicsemi.android.mesh.Range;

public abstract class AddressRange
extends Range {
    @Expose
    int lowAddress;
    @Expose
    int highAddress;

    public abstract int getLowAddress();

    public abstract int getHighAddress();

    @Override
    public int range() {
        return this.highAddress - this.lowAddress;
    }

    @Override
    public boolean overlaps(@NonNull Range otherRange) {
        if (otherRange instanceof AddressRange) {
            AddressRange otherAddressRange = (AddressRange)otherRange;
            return this.overlaps(this.lowAddress, this.highAddress, otherAddressRange.getLowAddress(), otherAddressRange.getHighAddress());
        }
        return false;
    }

    @NonNull
    public static List<AllocatedGroupRange> minus(@NonNull List<AllocatedGroupRange> ranges, @NonNull AllocatedGroupRange other) {
        List<AllocatedGroupRange> results = new ArrayList<AllocatedGroupRange>();
        for (AllocatedGroupRange range : ranges) {
            results.addAll(range.minus(other));
            results = AddressRange.mergeGroupRanges(results);
        }
        return results;
    }

    List<AllocatedGroupRange> minus(AllocatedGroupRange other) {
        ArrayList<AllocatedGroupRange> results = new ArrayList<AllocatedGroupRange>();
        if (other.lowAddress > this.lowAddress) {
            AllocatedGroupRange leftSlice = new AllocatedGroupRange(this.lowAddress, Math.min(this.highAddress, other.lowAddress - 1));
            results.add(leftSlice);
        }
        if (other.highAddress < this.highAddress) {
            AllocatedGroupRange rightSlice = new AllocatedGroupRange(Math.max(other.highAddress + 1, this.lowAddress), this.highAddress);
            results.add(rightSlice);
        }
        return results;
    }

    @NonNull
    public static List<AllocatedUnicastRange> minus(@NonNull List<AllocatedUnicastRange> ranges, @NonNull AllocatedUnicastRange other) {
        List<AllocatedUnicastRange> results = new ArrayList<AllocatedUnicastRange>();
        for (AllocatedUnicastRange range : ranges) {
            results.addAll(range.minus(other));
            results = AddressRange.mergeUnicastRanges(results);
        }
        return results;
    }

    List<AllocatedUnicastRange> minus(AllocatedUnicastRange other) {
        ArrayList<AllocatedUnicastRange> results = new ArrayList<AllocatedUnicastRange>();
        if (other.lowAddress > this.lowAddress) {
            AllocatedUnicastRange leftSlice = new AllocatedUnicastRange(this.lowAddress, Math.min(this.highAddress, other.lowAddress - 1));
            results.add(leftSlice);
        }
        if (other.highAddress < this.highAddress) {
            AllocatedUnicastRange rightSlice = new AllocatedUnicastRange(Math.max(other.highAddress + 1, this.lowAddress), this.highAddress);
            results.add(rightSlice);
        }
        return results;
    }

    public Boolean isInRange(int address) {
        return address >= this.lowAddress && address <= this.highAddress;
    }

    public static Boolean isAddressInAnyRanges(List<? extends AddressRange> ranges, int address) {
        for (AddressRange addressRange : ranges) {
            if (!addressRange.isInRange(address).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        AddressRange range = (AddressRange)o;
        return this.lowAddress == range.lowAddress && this.highAddress == range.highAddress;
    }

    @Override
    public int hashCode() {
        int result = this.lowAddress;
        result = 31 * result + this.highAddress;
        return result;
    }
}

