/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import no.nordicsemi.android.mesh.AllocatedGroupRange;
import no.nordicsemi.android.mesh.logger.MeshLogger;
import no.nordicsemi.android.mesh.utils.MeshAddress;

final class AllocatedGroupRangeDeserializer
implements JsonSerializer<List<AllocatedGroupRange>>,
JsonDeserializer<List<AllocatedGroupRange>> {
    private static final String TAG = AllocatedGroupRangeDeserializer.class.getSimpleName();

    AllocatedGroupRangeDeserializer() {
    }

    public List<AllocatedGroupRange> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        ArrayList<AllocatedGroupRange> groupRanges = new ArrayList<AllocatedGroupRange>();
        try {
            JsonArray jsonObject = json.getAsJsonArray();
            for (int i = 0; i < jsonObject.size(); ++i) {
                JsonObject unicastRangeJson = jsonObject.get(i).getAsJsonObject();
                int lowAddress = Integer.parseInt(unicastRangeJson.get("lowAddress").getAsString(), 16);
                int highAddress = Integer.parseInt(unicastRangeJson.get("highAddress").getAsString(), 16);
                groupRanges.add(new AllocatedGroupRange(lowAddress, highAddress));
            }
        }
        catch (Exception ex) {
            MeshLogger.error(TAG, "Error while de-serializing Allocated group range: " + ex.getMessage());
        }
        return groupRanges;
    }

    public JsonElement serialize(List<AllocatedGroupRange> ranges, Type typeOfSrc, JsonSerializationContext context) {
        JsonArray jsonArray = new JsonArray();
        for (AllocatedGroupRange range : ranges) {
            JsonObject rangeJson = new JsonObject();
            rangeJson.addProperty("lowAddress", MeshAddress.formatAddress(range.getLowAddress(), false));
            rangeJson.addProperty("highAddress", MeshAddress.formatAddress(range.getHighAddress(), false));
            jsonArray.add((JsonElement)rangeJson);
        }
        return jsonArray;
    }
}

