/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh;

import android.content.Context;
import android.content.SharedPreferences;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import no.nordicsemi.android.mesh.NetworkSettings;
import no.nordicsemi.android.mesh.utils.SecureUtils;

final class ProvisioningSettings
extends NetworkSettings {
    private static final String APPLICATION_KEYS = "APPLICATION_KEYS";
    private static final String PROVISIONING_DATA = "PROVISIONING_DATA";
    private static final String NETWORK_KEY = "NETWORK_KEY";
    private static final String UNICAST_ADDRESS = "UNICAST_ADDRESS";
    private static final String KEY_INDEX = "KEY_INDEX";
    private static final String IV_INDEX = "IV_INDEX";
    private static final String FLAGS = "FLAGS";
    private static final String GLOBAL_TTL = "GLOBAL_TTL";
    private final Context mContext;

    ProvisioningSettings(Context context) {
        this.mContext = context;
        this.generateProvisioningData();
    }

    @Override
    void generateProvisioningData() {
        SharedPreferences preferences = this.mContext.getSharedPreferences(PROVISIONING_DATA, 0);
        this.networkKey = preferences.getString(NETWORK_KEY, SecureUtils.generateRandomNetworkKey());
        this.unicastAddress = preferences.getInt(UNICAST_ADDRESS, 1);
        this.keyIndex = preferences.getInt(KEY_INDEX, 0);
        this.ivIndex = preferences.getInt(IV_INDEX, 0);
        this.flags = preferences.getInt(FLAGS, 0);
        this.globalTtl = preferences.getInt(GLOBAL_TTL, 5);
        this.addAppKeys();
    }

    void clearProvisioningData() {
        SharedPreferences preferences = this.mContext.getSharedPreferences(PROVISIONING_DATA, 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.clear();
        editor.apply();
    }

    private void addAppKeys() {
        SharedPreferences preferences = this.mContext.getSharedPreferences(APPLICATION_KEYS, 0);
        Map keys = preferences.getAll();
        if (!keys.isEmpty()) {
            this.appKeys.clear();
            for (int i = 0; i < keys.size(); ++i) {
                this.appKeys.add(i, String.valueOf(keys.get(String.valueOf(i))));
            }
        } else {
            this.appKeys.add(SecureUtils.generateRandomApplicationKey().toUpperCase(Locale.US));
            this.appKeys.add(SecureUtils.generateRandomApplicationKey().toUpperCase(Locale.US));
            this.appKeys.add(SecureUtils.generateRandomApplicationKey().toUpperCase(Locale.US));
        }
        this.saveApplicationKeys();
    }

    public final String getNetworkKey() {
        return this.networkKey;
    }

    public final void setNetworkKey(String networkKey) {
        this.networkKey = networkKey;
        this.saveNetworkKey();
    }

    public final List<String> getAppKeys() {
        return Collections.unmodifiableList(this.appKeys);
    }

    public final void addAppKey(String applicationKey) throws IllegalArgumentException {
        this.appKeys.add(applicationKey);
        this.saveApplicationKeys();
    }

    public final void addAppKey(int position, String applicationKey) {
        this.appKeys.add(position, applicationKey);
        this.saveApplicationKeys();
    }

    public final void updateAppKey(int position, String applicationKey) {
        if (this.appKeys.contains(applicationKey)) {
            throw new IllegalArgumentException("App key already exists");
        }
        this.appKeys.set(position, applicationKey);
        this.saveApplicationKeys();
    }

    public final void removeAppKey(String appKey) {
        if (this.appKeys.contains(appKey)) {
            int index = this.appKeys.indexOf(appKey);
            this.appKeys.remove(index);
            this.saveApplicationKeys();
        }
    }

    public final int getKeyIndex() {
        return this.keyIndex;
    }

    public final void setKeyIndex(int keyIndex) {
        this.keyIndex = keyIndex;
        this.saveKeyIndex();
    }

    public final int getIvIndex() {
        return this.ivIndex;
    }

    public final void setIvIndex(int ivIndex) {
        this.ivIndex = ivIndex;
        this.saveIvIndex();
    }

    public final int getUnicastAddress() {
        return this.unicastAddress;
    }

    public final void setUnicastAddress(int unicastAddress) {
        this.unicastAddress = unicastAddress;
        this.saveUnicastAddress();
    }

    public final int getFlags() {
        return this.flags;
    }

    public final void setFlags(int flags) {
        this.flags = flags;
        this.saveFlags();
    }

    public final int getGlobalTtl() {
        return this.globalTtl;
    }

    public final void setGlobalTtl(int globalTtl) {
        this.globalTtl = globalTtl;
        this.saveGlobalTtl();
    }

    private void saveNetworkKey() {
        SharedPreferences preferences = this.mContext.getSharedPreferences(PROVISIONING_DATA, 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString(NETWORK_KEY, this.networkKey);
        editor.apply();
    }

    private void saveUnicastAddress() {
        SharedPreferences preferences = this.mContext.getSharedPreferences(PROVISIONING_DATA, 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putInt(UNICAST_ADDRESS, this.unicastAddress);
        editor.apply();
    }

    private void saveKeyIndex() {
        SharedPreferences preferences = this.mContext.getSharedPreferences(PROVISIONING_DATA, 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putInt(KEY_INDEX, this.keyIndex);
        editor.apply();
    }

    private void saveIvIndex() {
        SharedPreferences preferences = this.mContext.getSharedPreferences(PROVISIONING_DATA, 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putInt(IV_INDEX, this.ivIndex);
        editor.apply();
    }

    private void saveFlags() {
        SharedPreferences preferences = this.mContext.getSharedPreferences(PROVISIONING_DATA, 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putInt(FLAGS, this.flags);
        editor.apply();
    }

    private void saveGlobalTtl() {
        SharedPreferences preferences = this.mContext.getSharedPreferences(PROVISIONING_DATA, 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putInt(GLOBAL_TTL, this.globalTtl);
        editor.apply();
    }

    private void saveApplicationKeys() {
    }
}

