/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.sensorutils;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import java.util.Arrays;
import no.nordicsemi.android.mesh.sensorutils.DevicePropertyCharacteristic;

public class Energy32
extends DevicePropertyCharacteristic<Double> {
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public Energy32(@NonNull byte[] data, int offset) {
        super(data, offset);
        byte[] bytes;
        long bits = 0L;
        for (byte b : bytes = Arrays.copyOfRange(data, offset, offset + this.getLength())) {
            bits = bits >> 8 | ((long)b & 0xFFL) << 24;
        }
        this.value = bits == 0xFFFFFFFFL || bits == 0xFFFFFFFEL ? null : Double.valueOf((double)bits / 1000.0);
    }

    public Energy32(double energy) {
        this.value = energy;
    }

    @NonNull
    public String toString() {
        return this.value + " kWh";
    }

    @Override
    public int getLength() {
        return 4;
    }

    @Override
    public byte[] getBytes() {
        byte[] bytes = new byte[]{-1, -1, -1, -1};
        if (this.value != null) {
            long value = (long)((Double)this.value * 1000.0 + 0.5);
            for (int n = 0; n < 4; ++n) {
                bytes[n] = (byte)(value >> n * 8 & 0xFFL);
            }
        }
        return bytes;
    }
}

