/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.sensorutils;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import no.nordicsemi.android.mesh.sensorutils.DevicePropertyCharacteristic;

public class FixedString
extends DevicePropertyCharacteristic<String> {
    final int length;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public FixedString(@NonNull byte[] data, int offset, int length) {
        super(data, offset, length);
        this.length = length;
        this.value = new String(data, offset, length, Charset.forName("UTF-8"));
    }

    public FixedString(@NonNull String fixedString) {
        this.length = this.parseLength(fixedString);
        this.value = fixedString;
    }

    private int parseLength(String fixedString) {
        int length = fixedString.getBytes().length;
        if (length > 0 && length <= 8) {
            return 8;
        }
        if (length > 8 && length <= 16) {
            return 16;
        }
        if (length > 16 && length <= 24) {
            return 24;
        }
        if (length > 24 && length <= 36) {
            return 36;
        }
        if (length > 36 && length <= 64) {
            return 64;
        }
        throw new IllegalArgumentException("Invalid length");
    }

    @NonNull
    public String toString() {
        return (String)this.value;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public byte[] getBytes() {
        return ByteBuffer.allocate(this.parseLength((String)this.value)).put(((String)this.value).getBytes()).array();
    }
}

