/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.sensorutils;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import no.nordicsemi.android.mesh.sensorutils.DevicePropertyCharacteristic;

public class Power
extends DevicePropertyCharacteristic<Float> {
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public Power(@NonNull byte[] data, int offset) {
        super(data, offset);
        int bits = (data[offset + 2] & 0xFF) << 16 | (data[offset + 1] & 0xFF) << 8 | data[offset] & 0xFF;
        this.value = bits == 0xFFFFFF ? null : Float.valueOf((float)bits / 10.0f);
    }

    public Power(float power) {
        this.value = Float.valueOf(power);
    }

    @NonNull
    public String toString() {
        return this.value + " W";
    }

    @Override
    public int getLength() {
        return 3;
    }

    @Override
    public byte[] getBytes() {
        byte[] bytes = new byte[]{-1, -1, -1};
        if (this.value != null) {
            int bits = (int)(((Float)this.value).floatValue() * 10.0f + 0.5f);
            for (int n = 0; n < 3; ++n) {
                bytes[n] = (byte)(bits >> n * 8 & 0xFF);
            }
        }
        return bytes;
    }
}

