/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import androidx.annotation.NonNull;
import no.nordicsemi.android.mesh.NetworkKey;
import no.nordicsemi.android.mesh.logger.MeshLogger;
import no.nordicsemi.android.mesh.transport.ConfigMessage;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;

public class ConfigKeyRefreshPhaseSet
extends ConfigMessage {
    private static final String TAG = ConfigKeyRefreshPhaseSet.class.getSimpleName();
    private static final int OP_CODE = 32790;
    private final NetworkKey mNetKey;
    private final int transition;

    public ConfigKeyRefreshPhaseSet(@NonNull NetworkKey networkKey, int transition) {
        this.mNetKey = networkKey;
        this.transition = transition;
        this.assembleMessageParameters();
    }

    @Override
    public int getOpCode() {
        return 32790;
    }

    @Override
    void assembleMessageParameters() {
        MeshLogger.debug(TAG, "NetKeyIndex: " + this.mNetKey.getKeyIndex());
        byte[] netKeyIndex = MeshParserUtils.addKeyIndexPadding(this.mNetKey.getKeyIndex());
        this.mParameters = new byte[]{netKeyIndex[1], (byte)(netKeyIndex[0] & 0xFF & 0xF), (byte)this.transition};
    }
}

