/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import no.nordicsemi.android.mesh.logger.MeshLogger;
import no.nordicsemi.android.mesh.transport.AccessMessage;
import no.nordicsemi.android.mesh.transport.ConfigStatusMessage;
import no.nordicsemi.android.mesh.utils.MeshAddress;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;

public class ConfigModelAppStatus
extends ConfigStatusMessage
implements Parcelable {
    private static final String TAG = ConfigModelAppStatus.class.getSimpleName();
    private static final int OP_CODE = 32830;
    private static final int CONFIG_MODEL_APP_BIND_STATUS_SIG_MODEL = 7;
    private static final int CONFIG_MODEL_APP_BIND_STATUS_VENDOR_MODEL = 9;
    private int mElementAddress;
    private int mAppKeyIndex;
    private int mModelIdentifier;
    private static final Parcelable.Creator<ConfigModelAppStatus> CREATOR = new Parcelable.Creator<ConfigModelAppStatus>(){

        public ConfigModelAppStatus createFromParcel(Parcel in) {
            AccessMessage message = (AccessMessage)in.readParcelable(AccessMessage.class.getClassLoader());
            return new ConfigModelAppStatus(message);
        }

        public ConfigModelAppStatus[] newArray(int size) {
            return new ConfigModelAppStatus[size];
        }
    };

    public ConfigModelAppStatus(@NonNull AccessMessage message) {
        super(message);
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    @Override
    final void parseStatusParameters() {
        AccessMessage message = (AccessMessage)this.mMessage;
        ByteBuffer buffer = ByteBuffer.wrap(message.getParameters()).order(ByteOrder.LITTLE_ENDIAN);
        buffer.position(0);
        this.mStatusCode = buffer.get();
        this.mStatusCodeName = this.getStatusCodeName(this.mStatusCode);
        this.mElementAddress = MeshParserUtils.unsignedBytesToInt(this.mParameters[1], this.mParameters[2]);
        byte[] appKeyIndex = new byte[]{(byte)(this.mParameters[4] & 0xF), this.mParameters[3]};
        this.mAppKeyIndex = ByteBuffer.wrap(appKeyIndex).order(ByteOrder.BIG_ENDIAN).getShort();
        if (this.mParameters.length == 7) {
            this.mModelIdentifier = MeshParserUtils.unsignedBytesToInt(this.mParameters[5], this.mParameters[6]);
        } else {
            byte[] modelIdentifier = new byte[]{this.mParameters[6], this.mParameters[5], this.mParameters[8], this.mParameters[7]};
            this.mModelIdentifier = ByteBuffer.wrap(modelIdentifier).order(ByteOrder.BIG_ENDIAN).getInt();
        }
        MeshLogger.verbose(TAG, "Status code: " + this.mStatusCode);
        MeshLogger.verbose(TAG, "Status message: " + this.mStatusCodeName);
        MeshLogger.verbose(TAG, "Element address: " + MeshAddress.formatAddress(this.mElementAddress, false));
        MeshLogger.verbose(TAG, "App key index: " + MeshParserUtils.bytesToHex(appKeyIndex, false));
        MeshLogger.verbose(TAG, "Model identifier: " + Integer.toHexString(this.mModelIdentifier));
    }

    @Override
    public int getOpCode() {
        return 32830;
    }

    public int getElementAddress() {
        return this.mElementAddress;
    }

    public final int getAppKeyIndex() {
        return this.mAppKeyIndex;
    }

    public final int getModelIdentifier() {
        return this.mModelIdentifier;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        AccessMessage message = (AccessMessage)this.mMessage;
        dest.writeParcelable((Parcelable)message, flags);
    }

    public boolean isSuccessful() {
        return this.mStatusCode == 0;
    }
}

