/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import no.nordicsemi.android.mesh.transport.ConfigMessage;

public final class ConfigRelaySet
extends ConfigMessage {
    public static final int RELAY_FEATURE_DISABLED = 0;
    public static final int RELAY_FEATURE_ENABLED = 1;
    public static final int RELAY_FEATURE_SUPPORTED = 2;
    private static final String TAG = ConfigRelaySet.class.getSimpleName();
    private static final int OP_CODE = 32807;
    private final int mRelay;
    private final int mRelayRetransmitCount;
    private final int mRelayRetransmitIntervalSteps;

    public ConfigRelaySet(int relay, int relayRetransmitCount, int relayRetransmitIntervalSteps) throws IllegalArgumentException {
        this.mRelay = relay;
        if (relayRetransmitCount < 0 || 7 < relayRetransmitCount) {
            throw new IllegalArgumentException("Network Transmit Count must be between 0 and 7 (inclusive)");
        }
        if (relayRetransmitIntervalSteps < 0 || 31 < relayRetransmitIntervalSteps) {
            throw new IllegalArgumentException("Network Transmit Interval Steps must be between 0 and 31 (inclusive)");
        }
        this.mRelayRetransmitCount = relayRetransmitCount;
        this.mRelayRetransmitIntervalSteps = relayRetransmitIntervalSteps;
        this.assembleMessageParameters();
    }

    @Override
    final void assembleMessageParameters() {
        this.mParameters = new byte[]{(byte)this.mRelay, (byte)(this.mRelayRetransmitIntervalSteps << 3 | this.mRelayRetransmitCount)};
    }

    @Override
    public int getOpCode() {
        return 32807;
    }

    public int getNetworkTransmitCount() {
        return this.mRelayRetransmitCount;
    }

    public int getNetworkTransmitIntervalSteps() {
        return this.mRelayRetransmitIntervalSteps;
    }
}

