/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import no.nordicsemi.android.mesh.logger.MeshLogger;
import no.nordicsemi.android.mesh.transport.ConfigMessage;
import no.nordicsemi.android.mesh.utils.CompositionDataParser;
import no.nordicsemi.android.mesh.utils.MeshAddress;

public class ConfigVendorModelAppGet
extends ConfigMessage {
    private static final String TAG = ConfigVendorModelAppGet.class.getSimpleName();
    private static final int OP_CODE = 32845;
    private static final int VENDOR_MODEL_APP_GET_PARAMS_LENGTH = 6;
    private final int elementAddress;
    private final int modelIdentifier;

    public ConfigVendorModelAppGet(int elementAddress, int modelIdentifier) throws IllegalArgumentException {
        if (!MeshAddress.isValidUnicastAddress(elementAddress)) {
            throw new IllegalArgumentException("Invalid unicast address, unicast address must be a 16-bit value, and must range from 0x0001 to 0x7FFF");
        }
        this.elementAddress = elementAddress;
        this.modelIdentifier = modelIdentifier;
        this.assembleMessageParameters();
    }

    @Override
    public int getOpCode() {
        return 32845;
    }

    @Override
    void assembleMessageParameters() {
        MeshLogger.verbose(TAG, "Element address: " + MeshAddress.formatAddress(this.elementAddress, true));
        MeshLogger.verbose(TAG, "Model: " + CompositionDataParser.formatModelIdentifier(this.modelIdentifier, false));
        ByteBuffer paramsBuffer = ByteBuffer.allocate(6).order(ByteOrder.LITTLE_ENDIAN);
        paramsBuffer.putShort((short)this.elementAddress);
        byte[] modelIdentifier = new byte[]{(byte)(this.modelIdentifier >> 24 & 0xFF), (byte)(this.modelIdentifier >> 16 & 0xFF), (byte)(this.modelIdentifier >> 8 & 0xFF), (byte)(this.modelIdentifier & 0xFF)};
        paramsBuffer.put(modelIdentifier[1]);
        paramsBuffer.put(modelIdentifier[0]);
        paramsBuffer.put(modelIdentifier[3]);
        paramsBuffer.put(modelIdentifier[2]);
        this.mParameters = paramsBuffer.array();
    }

    public int getElementAddress() {
        return this.elementAddress;
    }

    public int getModelIdentifier() {
        return this.modelIdentifier;
    }
}

