/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import java.security.InvalidParameterException;
import no.nordicsemi.android.mesh.data.GenericTransitionTime;
import no.nordicsemi.android.mesh.logger.MeshLogger;
import no.nordicsemi.android.mesh.transport.AccessMessage;
import no.nordicsemi.android.mesh.transport.ApplicationStatusMessage;
import no.nordicsemi.android.mesh.utils.ArrayUtils;
import no.nordicsemi.android.mesh.utils.BitReader;
import no.nordicsemi.android.mesh.utils.MeshAddress;

public class GenericDefaultTransitionTimeStatus
extends ApplicationStatusMessage
implements Parcelable {
    private static final String TAG = GenericDefaultTransitionTimeStatus.class.getSimpleName();
    private static final int OP_CODE = 33296;
    private static final int GENERIC_DEFAULT_TRANSITION_TIME_STATUS_LENGTH = 1;
    private GenericTransitionTime genericTransitionTime;
    private static final Parcelable.Creator<GenericDefaultTransitionTimeStatus> CREATOR = new Parcelable.Creator<GenericDefaultTransitionTimeStatus>(){

        public GenericDefaultTransitionTimeStatus createFromParcel(Parcel in) {
            AccessMessage message = (AccessMessage)in.readParcelable(AccessMessage.class.getClassLoader());
            return new GenericDefaultTransitionTimeStatus(message);
        }

        public GenericDefaultTransitionTimeStatus[] newArray(int size) {
            return new GenericDefaultTransitionTimeStatus[size];
        }
    };

    public GenericDefaultTransitionTimeStatus(@NonNull AccessMessage message) {
        super(message);
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        AccessMessage message = (AccessMessage)this.mMessage;
        parcel.writeParcelable((Parcelable)message, flags);
    }

    @Override
    void parseStatusParameters() {
        MeshLogger.verbose(TAG, "Received default transition time status from: " + MeshAddress.formatAddress(this.mMessage.getSrc(), true));
        if (this.mParameters.length == 1) {
            BitReader bitReader = new BitReader(ArrayUtils.reverseArray(this.mParameters));
            try {
                this.genericTransitionTime = new GenericTransitionTime(bitReader.getBits(1));
                MeshLogger.verbose(TAG, "Parsed Transition time status: " + this.genericTransitionTime.toString());
            }
            catch (InvalidParameterException e) {
                MeshLogger.verbose(TAG, "Couldn't parse TransitionTime.");
            }
        }
    }

    @Override
    public int getOpCode() {
        return 33296;
    }

    public GenericTransitionTime getGenericTransitionTime() {
        return this.genericTransitionTime;
    }
}

