/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import no.nordicsemi.android.mesh.logger.MeshLogger;
import no.nordicsemi.android.mesh.transport.AccessMessage;
import no.nordicsemi.android.mesh.transport.ApplicationStatusMessage;
import no.nordicsemi.android.mesh.utils.MeshAddress;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;

public final class GenericLevelStatus
extends ApplicationStatusMessage
implements Parcelable {
    private static final String TAG = GenericLevelStatus.class.getSimpleName();
    private static final int GENERIC_LEVEL_STATUS_MANDATORY_LENGTH = 2;
    private static final int OP_CODE = 33288;
    private int mPresentLevel;
    private Integer mTargetLevel;
    private int mTransitionSteps;
    private int mTransitionResolution;
    private static final Parcelable.Creator<GenericLevelStatus> CREATOR = new Parcelable.Creator<GenericLevelStatus>(){

        public GenericLevelStatus createFromParcel(Parcel in) {
            AccessMessage message = (AccessMessage)in.readParcelable(AccessMessage.class.getClassLoader());
            return new GenericLevelStatus(message);
        }

        public GenericLevelStatus[] newArray(int size) {
            return new GenericLevelStatus[size];
        }
    };

    public GenericLevelStatus(@NonNull AccessMessage message) {
        super(message);
        this.mMessage = message;
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    @Override
    void parseStatusParameters() {
        MeshLogger.verbose(TAG, "Received generic level status from: " + MeshAddress.formatAddress(this.mMessage.getSrc(), true));
        ByteBuffer buffer = ByteBuffer.wrap(this.mParameters).order(ByteOrder.LITTLE_ENDIAN);
        this.mPresentLevel = buffer.getShort();
        MeshLogger.verbose(TAG, "Present level: " + this.mPresentLevel);
        if (buffer.limit() > 2) {
            this.mTargetLevel = buffer.getShort();
            int remainingTime = buffer.get() & 0xFF;
            this.mTransitionSteps = remainingTime & 0x3F;
            this.mTransitionResolution = remainingTime >> 6;
            MeshLogger.verbose(TAG, "Target level: " + this.mTargetLevel);
            MeshLogger.verbose(TAG, "Remaining time, transition number of steps: " + this.mTransitionSteps);
            MeshLogger.verbose(TAG, "Remaining time, transition number of step resolution: " + this.mTransitionResolution);
            MeshLogger.verbose(TAG, "Remaining time: " + MeshParserUtils.getRemainingTime(remainingTime));
        }
    }

    @Override
    public int getOpCode() {
        return 33288;
    }

    public final int getPresentLevel() {
        return this.mPresentLevel;
    }

    public final Integer getTargetLevel() {
        return this.mTargetLevel;
    }

    public int getTransitionSteps() {
        return this.mTransitionSteps;
    }

    public int getTransitionResolution() {
        return this.mTransitionResolution;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        AccessMessage message = (AccessMessage)this.mMessage;
        dest.writeParcelable((Parcelable)message, flags);
    }
}

