/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import java.security.InvalidParameterException;
import no.nordicsemi.android.mesh.data.OnPowerUpState;
import no.nordicsemi.android.mesh.logger.MeshLogger;
import no.nordicsemi.android.mesh.transport.AccessMessage;
import no.nordicsemi.android.mesh.transport.ApplicationStatusMessage;
import no.nordicsemi.android.mesh.utils.ArrayUtils;
import no.nordicsemi.android.mesh.utils.BitReader;
import no.nordicsemi.android.mesh.utils.MeshAddress;

public class GenericOnPowerUpStatus
extends ApplicationStatusMessage
implements Parcelable {
    private static final String TAG = GenericOnPowerUpStatus.class.getSimpleName();
    private static final int OP_CODE = 33298;
    private static final int GENERIC_ON_POWER_UP_STATUS_LENGTH = 8;
    private OnPowerUpState onPowerUpState = OnPowerUpState.BT_MESH_UNKNOWN;
    private static final Parcelable.Creator<GenericOnPowerUpStatus> CREATOR = new Parcelable.Creator<GenericOnPowerUpStatus>(){

        public GenericOnPowerUpStatus createFromParcel(Parcel in) {
            AccessMessage message = (AccessMessage)in.readParcelable(AccessMessage.class.getClassLoader());
            return new GenericOnPowerUpStatus(message);
        }

        public GenericOnPowerUpStatus[] newArray(int size) {
            return new GenericOnPowerUpStatus[size];
        }
    };

    public GenericOnPowerUpStatus(@NonNull AccessMessage message) {
        super(message);
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        AccessMessage message = (AccessMessage)this.mMessage;
        dest.writeParcelable((Parcelable)message, flags);
    }

    @Override
    void parseStatusParameters() {
        MeshLogger.verbose(TAG, "Received generic power up status from: " + MeshAddress.formatAddress(this.mMessage.getSrc(), true));
        if (this.mParameters.length == 1) {
            BitReader bitReader = new BitReader(ArrayUtils.reverseArray(this.mParameters));
            try {
                this.onPowerUpState = OnPowerUpState.fromValue(bitReader.getBits(8));
            }
            catch (InvalidParameterException e) {
                MeshLogger.verbose(TAG, "Couldn't parse on power up state.");
            }
            MeshLogger.verbose(TAG, "Generic on power up status has state: " + (Object)((Object)this.onPowerUpState));
        }
    }

    @Override
    public int getOpCode() {
        return 33298;
    }

    public OnPowerUpState getOnPowerUpState() {
        return this.onPowerUpState;
    }
}

