/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import androidx.annotation.NonNull;
import no.nordicsemi.android.mesh.logger.MeshLogger;
import no.nordicsemi.android.mesh.transport.AccessMessage;
import no.nordicsemi.android.mesh.transport.ApplicationStatusMessage;
import no.nordicsemi.android.mesh.utils.MeshAddress;

public class HealthCurrentStatus
extends ApplicationStatusMessage {
    private static final String TAG = HealthCurrentStatus.class.getSimpleName();
    private static final int HEALTH_CURRENT_STATUS_MANDATORY_LENGTH = 3;
    private static final int OP_CODE = 4;
    private int mTestId;
    private int mCompanyId;
    private byte[] mFaultArray;

    public HealthCurrentStatus(@NonNull AccessMessage message) {
        super(message);
        this.mMessage = message;
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    @Override
    void parseStatusParameters() {
        MeshLogger.verbose(TAG, "Received health current status from: " + MeshAddress.formatAddress(this.mMessage.getSrc(), true));
        this.mTestId = this.mParameters[0] & 0xFF;
        this.mCompanyId = this.mParameters[1] & 0xFF | (this.mParameters[2] & 0xFF) << 8;
        MeshLogger.verbose(TAG, "Test ID: " + this.mTestId);
        MeshLogger.verbose(TAG, "Company ID: " + this.mCompanyId);
        if (this.mParameters.length > 3) {
            this.mFaultArray = new byte[this.mParameters.length - 3];
            System.arraycopy(this.mParameters, 3, this.mFaultArray, 0, this.mParameters.length - 3);
        }
    }

    @Override
    public int getOpCode() {
        return 4;
    }

    public int getTestId() {
        return this.mTestId;
    }

    public int getCompanyId() {
        return this.mCompanyId;
    }

    public byte[] getFaultArray() {
        return this.mFaultArray;
    }
}

