/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import no.nordicsemi.android.mesh.logger.MeshLogger;
import no.nordicsemi.android.mesh.transport.AccessMessage;
import no.nordicsemi.android.mesh.transport.ApplicationStatusMessage;
import no.nordicsemi.android.mesh.utils.MeshAddress;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;

public final class LightCtlStatus
extends ApplicationStatusMessage
implements Parcelable {
    private static final String TAG = LightCtlStatus.class.getSimpleName();
    private static final int LIGHT_CTL_STATUS_MANDATORY_LENGTH = 4;
    private static final int OP_CODE = 33376;
    private int mPresentCtlLightness;
    private int mPresentCtlTemperature;
    private Integer mTargetCtlLightness;
    private Integer mTargetCtlTemperature;
    private int mTransitionSteps;
    private int mTransitionResolution;
    private static final Parcelable.Creator<LightCtlStatus> CREATOR = new Parcelable.Creator<LightCtlStatus>(){

        public LightCtlStatus createFromParcel(Parcel in) {
            AccessMessage message = (AccessMessage)in.readParcelable(AccessMessage.class.getClassLoader());
            return new LightCtlStatus(message);
        }

        public LightCtlStatus[] newArray(int size) {
            return new LightCtlStatus[size];
        }
    };

    public LightCtlStatus(@NonNull AccessMessage message) {
        super(message);
        this.mMessage = message;
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    @Override
    void parseStatusParameters() {
        MeshLogger.verbose(TAG, "Received light ctl status from: " + MeshAddress.formatAddress(this.mMessage.getSrc(), true));
        ByteBuffer buffer = ByteBuffer.wrap(this.mParameters).order(ByteOrder.LITTLE_ENDIAN);
        this.mPresentCtlLightness = buffer.getShort() & 0xFFFF;
        this.mPresentCtlTemperature = buffer.getShort() & 0xFFFF;
        MeshLogger.verbose(TAG, "Present lightness: " + this.mPresentCtlLightness);
        MeshLogger.verbose(TAG, "Present temperature: " + this.mPresentCtlTemperature);
        if (buffer.limit() > 4) {
            this.mTargetCtlLightness = buffer.getShort() & 0xFFFF;
            this.mTargetCtlTemperature = buffer.getShort() & 0xFFFF;
            int remainingTime = buffer.get() & 0xFF;
            this.mTransitionSteps = remainingTime & 0x3F;
            this.mTransitionResolution = remainingTime >> 6;
            MeshLogger.verbose(TAG, "Target lightness: " + this.mTargetCtlLightness);
            MeshLogger.verbose(TAG, "Target temperature: " + this.mTargetCtlTemperature);
            MeshLogger.verbose(TAG, "Remaining time, transition number of steps: " + this.mTransitionSteps);
            MeshLogger.verbose(TAG, "Remaining time, transition number of step resolution: " + this.mTransitionResolution);
            MeshLogger.verbose(TAG, "Remaining time: " + MeshParserUtils.getRemainingTime(remainingTime));
        }
    }

    @Override
    public int getOpCode() {
        return 33376;
    }

    public final int getPresentLightness() {
        return this.mPresentCtlLightness;
    }

    public final Integer getTargetLightness() {
        return this.mTargetCtlLightness;
    }

    public final int getPresentTemperature() {
        return this.mPresentCtlTemperature;
    }

    public final Integer getTargetTemperature() {
        return this.mTargetCtlTemperature;
    }

    public int getTransitionSteps() {
        return this.mTransitionSteps;
    }

    public int getTransitionResolution() {
        return this.mTransitionResolution;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        AccessMessage message = (AccessMessage)this.mMessage;
        dest.writeParcelable((Parcelable)message, flags);
    }
}

