/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import no.nordicsemi.android.mesh.ApplicationKey;
import no.nordicsemi.android.mesh.logger.MeshLogger;
import no.nordicsemi.android.mesh.transport.ApplicationMessage;
import no.nordicsemi.android.mesh.transport.LightCtlSet;
import no.nordicsemi.android.mesh.utils.SecureUtils;

public class LightHslSetUnacknowledged
extends ApplicationMessage {
    private static final String TAG = LightCtlSet.class.getSimpleName();
    private static final int OP_CODE = 33399;
    private static final int LIGHT_LIGHTNESS_SET_TRANSITION_PARAMS_LENGTH = 9;
    private static final int LIGHT_LIGHTNESS_SET_PARAMS_LENGTH = 7;
    private final Integer mTransitionSteps;
    private final Integer mTransitionResolution;
    private final Integer mDelay;
    private final int mLightness;
    private final int mHue;
    private final int mSaturation;
    private final int tId;

    public LightHslSetUnacknowledged(@NonNull ApplicationKey appKey, int lightLightness, int lightHue, int lightSaturation, int tId) throws IllegalArgumentException {
        this(appKey, null, null, null, lightLightness, lightHue, lightSaturation, tId);
    }

    public LightHslSetUnacknowledged(@NonNull ApplicationKey appKey, @Nullable Integer transitionSteps, @Nullable Integer transitionResolution, @Nullable Integer delay, int lightLightness, int lightHue, int lightSaturation, int tId) throws IllegalArgumentException {
        super(appKey);
        this.mTransitionSteps = transitionSteps;
        this.mTransitionResolution = transitionResolution;
        this.mDelay = delay;
        if (lightLightness < 0 || lightLightness > 65535) {
            throw new IllegalArgumentException("Light lightness value must be between 0 to 0xFFFF");
        }
        if (lightHue < 0 || lightHue > 65535) {
            throw new IllegalArgumentException("Light hue value must be between 0 to 0xFFFF");
        }
        if (lightSaturation < 0 || lightSaturation > 65535) {
            throw new IllegalArgumentException("Light hue value must be between 0 to 0xFFFF");
        }
        this.mLightness = lightLightness;
        this.mHue = lightHue;
        this.mSaturation = lightSaturation;
        this.tId = tId;
        this.assembleMessageParameters();
    }

    @Override
    public int getOpCode() {
        return 33399;
    }

    @Override
    void assembleMessageParameters() {
        ByteBuffer paramsBuffer;
        this.mAid = SecureUtils.calculateK4(this.mAppKey.getKey());
        MeshLogger.verbose(TAG, "Lightness: " + this.mLightness);
        MeshLogger.verbose(TAG, "Hue: " + this.mHue);
        MeshLogger.verbose(TAG, "Saturation: " + this.mSaturation);
        MeshLogger.verbose(TAG, "TID: " + (byte)this.tId);
        if (this.mTransitionSteps == null || this.mTransitionResolution == null || this.mDelay == null) {
            paramsBuffer = ByteBuffer.allocate(7).order(ByteOrder.LITTLE_ENDIAN);
            paramsBuffer.putShort((short)this.mLightness);
            paramsBuffer.putShort((short)this.mHue);
            paramsBuffer.putShort((short)this.mSaturation);
            paramsBuffer.put((byte)this.tId);
        } else {
            MeshLogger.verbose(TAG, "Transition steps: " + this.mTransitionSteps);
            MeshLogger.verbose(TAG, "Transition step resolution: " + this.mTransitionResolution);
            paramsBuffer = ByteBuffer.allocate(9).order(ByteOrder.LITTLE_ENDIAN);
            paramsBuffer.putShort((short)this.mLightness);
            paramsBuffer.putShort((short)this.mHue);
            paramsBuffer.putShort((short)this.mSaturation);
            paramsBuffer.put((byte)this.tId);
            paramsBuffer.put((byte)(this.mTransitionResolution << 6 | this.mTransitionSteps));
            int delay = this.mDelay;
            paramsBuffer.put((byte)delay);
        }
        this.mParameters = paramsBuffer.array();
    }
}

