/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.content.Context;
import android.os.Handler;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import java.util.UUID;
import no.nordicsemi.android.mesh.ApplicationKey;
import no.nordicsemi.android.mesh.logger.MeshLogger;
import no.nordicsemi.android.mesh.transport.AccessMessage;
import no.nordicsemi.android.mesh.transport.ControlMessage;
import no.nordicsemi.android.mesh.transport.LowerTransportLayerCallbacks;
import no.nordicsemi.android.mesh.transport.Message;
import no.nordicsemi.android.mesh.transport.NetworkLayer;
import no.nordicsemi.android.mesh.transport.NetworkLayerCallbacks;
import no.nordicsemi.android.mesh.transport.ProvisionedMeshNode;
import no.nordicsemi.android.mesh.transport.UpperTransportLayerCallbacks;
import no.nordicsemi.android.mesh.utils.MeshAddress;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;

final class MeshTransport
extends NetworkLayer {
    private static final String TAG = MeshTransport.class.getSimpleName();
    private static final int PROXY_CONFIGURATION_TTL = 0;

    MeshTransport(@NonNull Context context) {
        this.mContext = context;
        this.initHandler();
    }

    @VisibleForTesting(otherwise=4)
    MeshTransport(@NonNull Context context, @NonNull ProvisionedMeshNode node) {
        this.mContext = context;
        this.mMeshNode = node;
        this.initHandler();
    }

    @Override
    protected final void initHandler() {
        this.mHandler = new Handler(this.mContext.getMainLooper());
    }

    @Override
    protected final void setLowerTransportLayerCallbacks(@NonNull LowerTransportLayerCallbacks callbacks) {
        this.mLowerTransportLayerCallbacks = callbacks;
    }

    @Override
    final void setNetworkLayerCallbacks(@NonNull NetworkLayerCallbacks callbacks) {
        this.mNetworkLayerCallbacks = callbacks;
    }

    @Override
    final void setUpperTransportLayerCallbacks(@NonNull UpperTransportLayerCallbacks callbacks) {
        this.mUpperTransportLayerCallbacks = callbacks;
    }

    final ControlMessage createSegmentBlockAcknowledgementMessage(ControlMessage controlMessage) {
        this.createLowerTransportControlPDU(controlMessage);
        this.createNetworkLayerPDU(controlMessage);
        return controlMessage;
    }

    final AccessMessage createMeshMessage(int src, int dst, @Nullable Integer ttl, byte[] key, int akf, int aid, int aszmic, int accessOpCode, byte[] accessMessageParameters) {
        ProvisionedMeshNode node = this.mUpperTransportLayerCallbacks.getNode(src);
        int sequenceNumber = node.incrementSequenceNumber();
        byte[] sequenceNum = MeshParserUtils.getSequenceNumberBytes(sequenceNumber);
        MeshLogger.verbose(TAG, "Src address: " + MeshAddress.formatAddress(src, false));
        MeshLogger.verbose(TAG, "Dst address: " + MeshAddress.formatAddress(dst, false));
        MeshLogger.verbose(TAG, "Key: " + MeshParserUtils.bytesToHex(key, false));
        MeshLogger.verbose(TAG, "akf: " + akf);
        MeshLogger.verbose(TAG, "aid: " + aid);
        MeshLogger.verbose(TAG, "aszmic: " + aszmic);
        MeshLogger.verbose(TAG, "Sequence number: " + sequenceNumber);
        MeshLogger.verbose(TAG, "Access message opcode: " + Integer.toHexString(accessOpCode));
        MeshLogger.verbose(TAG, "Access message parameters: " + MeshParserUtils.bytesToHex(accessMessageParameters, false));
        AccessMessage message = new AccessMessage();
        message.setSrc(src);
        message.setDst(dst);
        message.setTtl(ttl == null ? node.getTtl() : ttl);
        message.setIvIndex(this.mUpperTransportLayerCallbacks.getIvIndex());
        message.setSequenceNumber(sequenceNum);
        message.setDeviceKey(key);
        message.setAkf(akf);
        message.setAid(aid);
        message.setAszmic(aszmic);
        message.setOpCode(accessOpCode);
        message.setParameters(accessMessageParameters);
        message.setPduType(0);
        super.createMeshMessage(message);
        return message;
    }

    final AccessMessage createMeshMessage(int src, int dst, @Nullable UUID label, @Nullable Integer ttl, @NonNull ApplicationKey key, int akf, int aid, int aszmic, int accessOpCode, @Nullable byte[] accessMessageParameters) {
        ProvisionedMeshNode node = this.mUpperTransportLayerCallbacks.getNode(src);
        int sequenceNumber = node.incrementSequenceNumber();
        byte[] sequenceNum = MeshParserUtils.getSequenceNumberBytes(sequenceNumber);
        MeshLogger.verbose(TAG, "Src address: " + MeshAddress.formatAddress(src, false));
        MeshLogger.verbose(TAG, "Dst address: " + MeshAddress.formatAddress(dst, false));
        MeshLogger.verbose(TAG, "Key: " + MeshParserUtils.bytesToHex(key.getKey(), false));
        MeshLogger.verbose(TAG, "akf: " + akf);
        MeshLogger.verbose(TAG, "aid: " + aid);
        MeshLogger.verbose(TAG, "aszmic: " + aszmic);
        MeshLogger.verbose(TAG, "Sequence number: " + sequenceNumber);
        MeshLogger.verbose(TAG, "Access message opcode: " + Integer.toHexString(accessOpCode));
        MeshLogger.verbose(TAG, "Access message parameters: " + MeshParserUtils.bytesToHex(accessMessageParameters, false));
        AccessMessage message = new AccessMessage();
        message.setSrc(src);
        message.setDst(dst);
        message.setTtl(ttl == null ? node.getTtl() : ttl);
        if (label != null) {
            message.setLabel(label);
        }
        message.setIvIndex(this.mUpperTransportLayerCallbacks.getIvIndex());
        message.setSequenceNumber(sequenceNum);
        message.setApplicationKey(key);
        message.setAkf(akf);
        message.setAid(aid);
        message.setAszmic(aszmic);
        message.setOpCode(accessOpCode);
        message.setParameters(accessMessageParameters);
        message.setPduType(0);
        super.createMeshMessage(message);
        return message;
    }

    final AccessMessage createVendorMeshMessage(int companyIdentifier, int src, int dst, @Nullable UUID label, @Nullable Integer ttl, @NonNull ApplicationKey key, int akf, int aid, int aszmic, int accessOpCode, @Nullable byte[] accessMessageParameters) {
        ProvisionedMeshNode node = this.mUpperTransportLayerCallbacks.getNode(src);
        int sequenceNumber = node.incrementSequenceNumber();
        byte[] sequenceNum = MeshParserUtils.getSequenceNumberBytes(sequenceNumber);
        MeshLogger.verbose(TAG, "Src address: " + MeshAddress.formatAddress(src, false));
        MeshLogger.verbose(TAG, "Dst address: " + MeshAddress.formatAddress(dst, false));
        MeshLogger.verbose(TAG, "Key: " + MeshParserUtils.bytesToHex(key.getKey(), false));
        MeshLogger.verbose(TAG, "akf: " + akf);
        MeshLogger.verbose(TAG, "aid: " + aid);
        MeshLogger.verbose(TAG, "aszmic: " + aszmic);
        MeshLogger.verbose(TAG, "Sequence number: " + sequenceNumber);
        MeshLogger.verbose(TAG, "Access message opcode: " + Integer.toHexString(accessOpCode));
        MeshLogger.verbose(TAG, "Access message parameters: " + MeshParserUtils.bytesToHex(accessMessageParameters, false));
        AccessMessage message = new AccessMessage();
        message.setCompanyIdentifier(companyIdentifier);
        message.setSrc(src);
        message.setDst(dst);
        message.setTtl(ttl == null ? node.getTtl() : ttl);
        if (label != null) {
            message.setLabel(label);
        }
        message.setIvIndex(this.mUpperTransportLayerCallbacks.getIvIndex());
        message.setSequenceNumber(sequenceNum);
        message.setApplicationKey(key);
        message.setAkf(akf);
        message.setAid(aid);
        message.setAszmic(aszmic);
        message.setOpCode(accessOpCode);
        message.setParameters(accessMessageParameters);
        message.setPduType(0);
        super.createVendorMeshMessage(message);
        return message;
    }

    final ControlMessage createProxyConfigurationMessage(int src, int dst, int opcode, byte[] parameters) {
        ProvisionedMeshNode node = this.mUpperTransportLayerCallbacks.getNode(src);
        int sequenceNumber = node.incrementSequenceNumber();
        byte[] sequenceNum = MeshParserUtils.getSequenceNumberBytes(sequenceNumber);
        MeshLogger.verbose(TAG, "Src address: " + MeshAddress.formatAddress(src, false));
        MeshLogger.verbose(TAG, "Dst address: " + MeshAddress.formatAddress(dst, false));
        MeshLogger.verbose(TAG, "Sequence number: " + sequenceNumber);
        MeshLogger.verbose(TAG, "Control message opcode: " + Integer.toHexString(opcode));
        MeshLogger.verbose(TAG, "Control message parameters: " + MeshParserUtils.bytesToHex(parameters, false));
        ControlMessage message = new ControlMessage();
        message.setSrc(src);
        message.setDst(dst);
        message.setTtl(node.getTtl());
        message.setTtl(0);
        message.setIvIndex(this.mUpperTransportLayerCallbacks.getIvIndex());
        message.setSequenceNumber(sequenceNum);
        message.setOpCode(opcode);
        message.setParameters(parameters);
        message.setPduType(2);
        super.createMeshMessage(message);
        return message;
    }

    final Message createRetransmitMeshMessage(Message message, int segment) {
        return this.createRetransmitNetworkLayerPDU(message, segment);
    }
}

