/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import java.security.InvalidParameterException;
import no.nordicsemi.android.mesh.data.ScheduleEntry;
import no.nordicsemi.android.mesh.logger.MeshLogger;
import no.nordicsemi.android.mesh.transport.AccessMessage;
import no.nordicsemi.android.mesh.transport.ApplicationStatusMessage;
import no.nordicsemi.android.mesh.utils.ArrayUtils;
import no.nordicsemi.android.mesh.utils.BitReader;
import no.nordicsemi.android.mesh.utils.MeshAddress;

public class SchedulerActionStatus
extends ApplicationStatusMessage
implements Parcelable {
    private static final String TAG = SchedulerActionStatus.class.getSimpleName();
    private static final int OP_CODE = 95;
    private static final int SCHEDULER_ACTION_STATUS_LENGTH = 10;
    private int index;
    private ScheduleEntry entry;
    private static final Parcelable.Creator<SchedulerActionStatus> CREATOR = new Parcelable.Creator<SchedulerActionStatus>(){

        public SchedulerActionStatus createFromParcel(Parcel in) {
            AccessMessage message = (AccessMessage)in.readParcelable(AccessMessage.class.getClassLoader());
            return new SchedulerActionStatus(message);
        }

        public SchedulerActionStatus[] newArray(int size) {
            return new SchedulerActionStatus[size];
        }
    };

    public SchedulerActionStatus(@NonNull AccessMessage message) {
        super(message);
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        AccessMessage message = (AccessMessage)this.mMessage;
        dest.writeParcelable((Parcelable)message, flags);
    }

    @Override
    void parseStatusParameters() {
        MeshLogger.verbose(TAG, "Received scheduler action status from: " + MeshAddress.formatAddress(this.mMessage.getSrc(), true));
        if (this.mParameters.length == 10) {
            BitReader bitReader = new BitReader(ArrayUtils.reverseArray(this.mParameters));
            try {
                this.entry = new ScheduleEntry(bitReader);
            }
            catch (InvalidParameterException e) {
                MeshLogger.verbose(TAG, "Couldn't parse ScheduleEntry.");
            }
            this.index = bitReader.getBits(4);
            MeshLogger.verbose(TAG, "Scheduler action status has index: " + this.index);
            MeshLogger.verbose(TAG, "Scheduler action status has entry: " + this.entry.toString());
        }
    }

    @Override
    public int getOpCode() {
        return 95;
    }

    public int getIndex() {
        return this.index;
    }

    public ScheduleEntry getEntry() {
        return this.entry;
    }
}

