/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import no.nordicsemi.android.mesh.sensorutils.DeviceProperty;
import no.nordicsemi.android.mesh.transport.AccessMessage;
import no.nordicsemi.android.mesh.transport.SceneStatuses;
import no.nordicsemi.android.mesh.transport.SensorMessage;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;

public final class SensorCadenceStatus
extends SensorMessage
implements Parcelable,
SceneStatuses {
    private static final String TAG = SensorCadenceStatus.class.getSimpleName();
    private static final int OP_CODE = 87;
    private SensorMessage.SensorCadence cadence;
    private static final Parcelable.Creator<SensorCadenceStatus> CREATOR = new Parcelable.Creator<SensorCadenceStatus>(){

        public SensorCadenceStatus createFromParcel(Parcel in) {
            AccessMessage message = (AccessMessage)in.readParcelable(AccessMessage.class.getClassLoader());
            return new SensorCadenceStatus(message);
        }

        public SensorCadenceStatus[] newArray(int size) {
            return new SensorCadenceStatus[size];
        }
    };

    public SensorCadenceStatus(@NonNull AccessMessage message) {
        super(message);
        this.mMessage = message;
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    @Override
    void parseStatusParameters() {
        DeviceProperty deviceProperty = DeviceProperty.from((short)MeshParserUtils.unsignedBytesToInt(this.mParameters[0], this.mParameters[1]));
        this.cadence = new SensorMessage.SensorCadence(this, deviceProperty, this.mParameters);
    }

    @Override
    public int getOpCode() {
        return 87;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        AccessMessage message = (AccessMessage)this.mMessage;
        dest.writeParcelable((Parcelable)message, flags);
    }

    public SensorMessage.SensorCadence getCadence() {
        return this.cadence;
    }
}

