/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import java.util.ArrayList;
import java.util.Arrays;
import no.nordicsemi.android.mesh.logger.MeshLogger;
import no.nordicsemi.android.mesh.sensorutils.DeviceProperty;
import no.nordicsemi.android.mesh.sensorutils.MarshalledPropertyId;
import no.nordicsemi.android.mesh.sensorutils.MarshalledSensorData;
import no.nordicsemi.android.mesh.transport.AccessMessage;
import no.nordicsemi.android.mesh.transport.ApplicationStatusMessage;
import no.nordicsemi.android.mesh.transport.SceneStatuses;
import no.nordicsemi.android.mesh.utils.SensorFormat;

public final class SensorStatus
extends ApplicationStatusMessage
implements Parcelable,
SceneStatuses {
    private static final String TAG = SensorStatus.class.getSimpleName();
    private static final int OP_CODE = 82;
    private final ArrayList<MarshalledSensorData> marshalledSensorDataList = new ArrayList();
    private static final Parcelable.Creator<SensorStatus> CREATOR = new Parcelable.Creator<SensorStatus>(){

        public SensorStatus createFromParcel(Parcel in) {
            AccessMessage message = (AccessMessage)in.readParcelable(AccessMessage.class.getClassLoader());
            return new SensorStatus(message);
        }

        public SensorStatus[] newArray(int size) {
            return new SensorStatus[size];
        }
    };

    public SensorStatus(@NonNull AccessMessage message) {
        super(message);
        this.mMessage = message;
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    @Override
    void parseStatusParameters() {
        int length;
        for (int offset = 0; offset < this.mParameters.length; offset += length) {
            short propertyId;
            int octet0 = this.mParameters[offset++] & 0xFF;
            int octet1 = this.mParameters[offset++] & 0xFF;
            SensorFormat sensorFormat = SensorFormat.from((byte)(octet0 & 1));
            switch (sensorFormat) {
                case FORMAT_A: {
                    length = ((octet0 & 0x1E) >> 1) + 1;
                    propertyId = (short)(octet1 << 3 | octet0 >> 5);
                    break;
                }
                case FORMAT_B: {
                    int octet2 = this.mParameters[offset++] & 0xFF;
                    int tempLength = (octet0 & 0xFE) >> 1;
                    length = tempLength == 127 ? 0 : tempLength;
                    propertyId = (short)(octet2 | octet1);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid data");
                }
            }
            MarshalledPropertyId marshalledPropertyId = new MarshalledPropertyId(sensorFormat, length, DeviceProperty.from(sensorFormat, propertyId));
            byte[] raw = Arrays.copyOfRange(this.mParameters, offset, offset + length);
            MarshalledSensorData marshalledSensorData = new MarshalledSensorData(marshalledPropertyId, raw);
            MeshLogger.debug(TAG, "Result: " + marshalledSensorData.toString());
            this.marshalledSensorDataList.add(marshalledSensorData);
        }
    }

    @Override
    public int getOpCode() {
        return 82;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        AccessMessage message = (AccessMessage)this.mMessage;
        dest.writeParcelable((Parcelable)message, flags);
    }

    public ArrayList<MarshalledSensorData> getMarshalledSensorData() {
        return this.marshalledSensorDataList;
    }
}

