/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import no.nordicsemi.android.mesh.data.TimeZoneOffset;
import no.nordicsemi.android.mesh.logger.MeshLogger;
import no.nordicsemi.android.mesh.transport.AccessMessage;
import no.nordicsemi.android.mesh.transport.ApplicationStatusMessage;
import no.nordicsemi.android.mesh.utils.MeshAddress;

public final class TimeZoneStatus
extends ApplicationStatusMessage
implements Parcelable {
    private static final String TAG = TimeZoneStatus.class.getSimpleName();
    private static final int OP_CODE = 33341;
    private static final int TIME_ZONE_STATUS_LENGTH = 7;
    private TimeZoneOffset currentTimeZoneOffset = TimeZoneOffset.of((byte)64);
    private TimeZoneOffset newTimeZoneOffset = TimeZoneOffset.of((byte)64);
    private long timeOfChange = 0L;
    private static final Parcelable.Creator<TimeZoneStatus> CREATOR = new Parcelable.Creator<TimeZoneStatus>(){

        public TimeZoneStatus createFromParcel(Parcel in) {
            AccessMessage message = (AccessMessage)in.readParcelable(AccessMessage.class.getClassLoader());
            return new TimeZoneStatus(message);
        }

        public TimeZoneStatus[] newArray(int size) {
            return new TimeZoneStatus[size];
        }
    };

    public TimeZoneStatus(@NonNull AccessMessage message) {
        super(message);
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        AccessMessage message = (AccessMessage)this.mMessage;
        dest.writeParcelable((Parcelable)message, flags);
    }

    @Override
    void parseStatusParameters() {
        MeshLogger.verbose(TAG, "Received time zone status from: " + MeshAddress.formatAddress(this.mMessage.getSrc(), true));
        if (this.mParameters.length == 7) {
            ByteBuffer buffer = ByteBuffer.wrap(this.mParameters).order(ByteOrder.LITTLE_ENDIAN);
            this.currentTimeZoneOffset = TimeZoneOffset.of(buffer.get());
            this.newTimeZoneOffset = TimeZoneOffset.of(buffer.get());
            this.timeOfChange = (long)buffer.getInt() & 0xFFFFFFFFL | ((long)buffer.get() & 0xFFL) << 32;
            MeshLogger.verbose(TAG, "current " + this.currentTimeZoneOffset.toString());
            MeshLogger.verbose(TAG, "new " + this.newTimeZoneOffset.toString());
            MeshLogger.verbose(TAG, "time of change: " + this.timeOfChange);
        }
    }

    @Override
    public int getOpCode() {
        return 33341;
    }

    @NonNull
    public TimeZoneOffset getCurrentTimeZoneOffset() {
        return this.currentTimeZoneOffset;
    }

    @NonNull
    public TimeZoneOffset getNewTimeZoneOffset() {
        return this.newTimeZoneOffset;
    }

    public long getTimeOfChange() {
        return this.timeOfChange;
    }
}

