/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import no.nordicsemi.android.mesh.AllocatedUnicastRange;
import no.nordicsemi.android.mesh.logger.MeshLogger;

final class AllocatedUnicastRangeDbMigrator
implements JsonDeserializer<List<AllocatedUnicastRange>> {
    private static final String TAG = AllocatedUnicastRangeDbMigrator.class.getSimpleName();

    AllocatedUnicastRangeDbMigrator() {
    }

    public List<AllocatedUnicastRange> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        ArrayList<AllocatedUnicastRange> unicastRanges = new ArrayList<AllocatedUnicastRange>();
        try {
            if (json.isJsonArray()) {
                JsonArray jsonObject = json.getAsJsonArray();
                for (int i = 0; i < jsonObject.size(); ++i) {
                    JsonObject unicastRangeJson = jsonObject.get(i).getAsJsonObject();
                    int lowAddress = unicastRangeJson.get("lowAddress").getAsInt();
                    int highAddress = unicastRangeJson.get("highAddress").getAsInt();
                    unicastRanges.add(new AllocatedUnicastRange(lowAddress, highAddress));
                }
            }
        }
        catch (Exception ex) {
            MeshLogger.error(TAG, "Error while de-serializing allocated unicast range: " + ex.getMessage());
        }
        return unicastRanges;
    }
}

