/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.data;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public abstract class GlobalLatitude {
    private static final int ENCODED_VALUE_NOT_CONFIGURED = Integer.MIN_VALUE;

    private GlobalLatitude() {
    }

    public abstract int getEncodedValue();

    @NonNull
    public static GlobalLatitude of(int encodedValue) {
        if (encodedValue == Integer.MIN_VALUE) {
            return new NotConfigured();
        }
        return new Coordinate(encodedValue);
    }

    @NonNull
    public static Coordinate encode(double position) {
        return new Coordinate(position);
    }

    @NonNull
    public static NotConfigured notConfigured() {
        return new NotConfigured();
    }

    @Nullable
    public Double getDecodedPosition() {
        if (this instanceof Coordinate) {
            return ((Coordinate)this).getPosition();
        }
        return null;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GlobalLatitude that = (GlobalLatitude)o;
        return this.getEncodedValue() == that.getEncodedValue();
    }

    public final int hashCode() {
        return Integer.valueOf(this.getEncodedValue()).hashCode();
    }

    @NonNull
    public String toString() {
        return "GlobalLatitude." + this.getClass().getSimpleName() + " encodedValue: " + Integer.toHexString(this.getEncodedValue()) + " position: " + this.getDecodedPosition();
    }

    public static final class NotConfigured
    extends GlobalLatitude {
        private NotConfigured() {
        }

        @Override
        public int getEncodedValue() {
            return Integer.MIN_VALUE;
        }
    }

    public static final class Coordinate
    extends GlobalLatitude {
        private final int encodedValue;

        private Coordinate(int encodedValue) {
            if (encodedValue == Integer.MIN_VALUE) {
                throw new IllegalArgumentException("Encoded value can't be \u00b4NOT CONFIGURED\u00b4 (0x80000000)");
            }
            this.encodedValue = encodedValue;
        }

        private Coordinate(double value) {
            if (value < -90.0 || value > 90.0) {
                throw new IllegalArgumentException("Latitude coordinate must be between -90 and 90 degrees inclusive");
            }
            int n = (int)Math.floor(value / 90.0 * (Math.pow(2.0, 31.0) - 1.0));
            this.encodedValue = Math.max(-2147483647, n);
        }

        @Override
        public int getEncodedValue() {
            return this.encodedValue;
        }

        public double getPosition() {
            return (double)this.encodedValue / (Math.pow(2.0, 31.0) - 1.0) * 90.0;
        }
    }
}

