/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.data;

import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.SharedSQLiteStatement;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.Collections;
import java.util.List;
import no.nordicsemi.android.mesh.NetworkKey;
import no.nordicsemi.android.mesh.data.NetworkKeyDao;

public final class NetworkKeyDao_Impl
implements NetworkKeyDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<NetworkKey> __insertionAdapterOfNetworkKey;
    private final EntityDeletionOrUpdateAdapter<NetworkKey> __updateAdapterOfNetworkKey;
    private final SharedSQLiteStatement __preparedStmtOfDelete;

    public NetworkKeyDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfNetworkKey = new EntityInsertionAdapter<NetworkKey>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `network_key` (`phase`,`security`,`timestamp`,`id`,`mesh_uuid`,`index`,`name`,`key`,`old_key`) VALUES (?,?,?,nullif(?, 0),?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, NetworkKey value) {
                stmt.bindLong(1, (long)value.getPhase());
                int _tmp = value.isMinSecurity() ? 1 : 0;
                stmt.bindLong(2, (long)_tmp);
                stmt.bindLong(3, value.getTimestamp());
                stmt.bindLong(4, (long)value.getId());
                if (value.getMeshUuid() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getMeshUuid());
                }
                stmt.bindLong(6, (long)value.getKeyIndex());
                if (value.getName() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getName());
                }
                if (value.getKey() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindBlob(8, value.getKey());
                }
                if (value.getOldKey() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindBlob(9, value.getOldKey());
                }
            }
        };
        this.__updateAdapterOfNetworkKey = new EntityDeletionOrUpdateAdapter<NetworkKey>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `network_key` SET `phase` = ?,`security` = ?,`timestamp` = ?,`id` = ?,`mesh_uuid` = ?,`index` = ?,`name` = ?,`key` = ?,`old_key` = ? WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, NetworkKey value) {
                stmt.bindLong(1, (long)value.getPhase());
                int _tmp = value.isMinSecurity() ? 1 : 0;
                stmt.bindLong(2, (long)_tmp);
                stmt.bindLong(3, value.getTimestamp());
                stmt.bindLong(4, (long)value.getId());
                if (value.getMeshUuid() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getMeshUuid());
                }
                stmt.bindLong(6, (long)value.getKeyIndex());
                if (value.getName() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getName());
                }
                if (value.getKey() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindBlob(8, value.getKey());
                }
                if (value.getOldKey() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindBlob(9, value.getOldKey());
                }
                stmt.bindLong(10, (long)value.getId());
            }
        };
        this.__preparedStmtOfDelete = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM network_key WHERE `index` = ?";
                return "DELETE FROM network_key WHERE `index` = ?";
            }
        };
    }

    @Override
    public void insert(NetworkKey networkKey) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfNetworkKey.insert((Object)networkKey);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update(NetworkKey networkKey) {
        this.__db.assertNotSuspendingTransaction();
        int _total = 0;
        this.__db.beginTransaction();
        try {
            this.__db.setTransactionSuccessful();
            int n = _total += this.__updateAdapterOfNetworkKey.handle((Object)networkKey);
            return n;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int delete(int index) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDelete.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, (long)index);
        this.__db.beginTransaction();
        try {
            int _result = _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
            int n = _result;
            return n;
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDelete.release(_stmt);
        }
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

