/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.models;

import android.os.Parcel;
import android.os.Parcelable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import no.nordicsemi.android.mesh.logger.MeshLogger;
import no.nordicsemi.android.mesh.transport.MeshModel;
import no.nordicsemi.android.mesh.utils.CompanyIdentifiers;

public class VendorModel
extends MeshModel {
    private static final String TAG = VendorModel.class.getSimpleName();
    private final short companyIdentifier;
    private final String companyName;
    public static final Parcelable.Creator<VendorModel> CREATOR = new Parcelable.Creator<VendorModel>(){

        public VendorModel createFromParcel(Parcel source) {
            return new VendorModel(source);
        }

        public VendorModel[] newArray(int size) {
            return new VendorModel[size];
        }
    };

    public VendorModel(int modelIdentifier) {
        super(modelIdentifier);
        ByteBuffer buffer = ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN);
        buffer.putInt(modelIdentifier);
        this.companyIdentifier = buffer.getShort(0);
        this.companyName = CompanyIdentifiers.getCompanyName(this.companyIdentifier);
        MeshLogger.verbose(TAG, "Company name: " + this.companyName);
    }

    private VendorModel(Parcel source) {
        super(source);
        ByteBuffer buffer = ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN);
        buffer.putInt(this.mModelId);
        this.companyIdentifier = buffer.getShort(0);
        this.companyName = CompanyIdentifiers.getCompanyName(this.companyIdentifier);
    }

    @Override
    public int getModelId() {
        return this.mModelId;
    }

    @Override
    public String getModelName() {
        return "Vendor Model";
    }

    public int getCompanyIdentifier() {
        return this.companyIdentifier;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        super.parcelMeshModel(dest, flags);
    }
}

