/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.provisionerstates;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.nio.ByteBuffer;
import no.nordicsemi.android.mesh.InternalProvisioningCallbacks;
import no.nordicsemi.android.mesh.InternalTransportCallbacks;
import no.nordicsemi.android.mesh.MeshProvisioningStatusCallbacks;
import no.nordicsemi.android.mesh.logger.MeshLogger;
import no.nordicsemi.android.mesh.provisionerstates.ProvisioningState;
import no.nordicsemi.android.mesh.provisionerstates.UnprovisionedMeshNode;
import no.nordicsemi.android.mesh.utils.InputOOBAction;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;
import no.nordicsemi.android.mesh.utils.OutputOOBAction;
import no.nordicsemi.android.mesh.utils.SecureUtils;

public class ProvisioningConfirmationState
extends ProvisioningState {
    private final String TAG = ProvisioningConfirmationState.class.getSimpleName();
    private static final byte[] NO_OOB_AUTH = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final int AUTH_VALUE_LENGTH = 16;
    private final InternalProvisioningCallbacks provisioningCallbacks;
    private final UnprovisionedMeshNode mNode;
    private final MeshProvisioningStatusCallbacks mStatusCallbacks;
    private final InternalTransportCallbacks mInternalTransportCallbacks;
    private String authentication;

    public ProvisioningConfirmationState(@NonNull UnprovisionedMeshNode node, @NonNull InternalProvisioningCallbacks callbacks, @NonNull InternalTransportCallbacks internalTransportCallbacks, @NonNull MeshProvisioningStatusCallbacks provisioningStatusCallbacks) {
        this.provisioningCallbacks = callbacks;
        this.mNode = node;
        this.mInternalTransportCallbacks = internalTransportCallbacks;
        this.mStatusCallbacks = provisioningStatusCallbacks;
    }

    public void setProvisioningAuthentication(@Nullable String authentication) {
        this.authentication = authentication;
    }

    @Override
    public ProvisioningState.State getState() {
        return ProvisioningState.State.PROVISIONING_CONFIRMATION;
    }

    @Override
    public void executeSend() {
        byte[] provisioningConfirmationPDU = this.createProvisioningConfirmation();
        this.mStatusCallbacks.onProvisioningStateChanged(this.mNode, ProvisioningState.States.PROVISIONING_CONFIRMATION_SENT, provisioningConfirmationPDU);
        this.mInternalTransportCallbacks.sendProvisioningPdu(this.mNode, provisioningConfirmationPDU);
    }

    @Override
    public boolean parseData(@NonNull byte[] data) {
        this.mStatusCallbacks.onProvisioningStateChanged(this.mNode, ProvisioningState.States.PROVISIONING_CONFIRMATION_RECEIVED, data);
        this.parseProvisioneeConfirmation(data);
        return true;
    }

    private byte[] createProvisioningConfirmation() {
        byte[] confirmationInputs = this.provisioningCallbacks.generateConfirmationInputs(this.mNode.getProvisionerPublicKeyXY(), this.mNode.getProvisioneePublicKeyXY());
        MeshLogger.verbose(this.TAG, "Confirmation inputs: " + MeshParserUtils.bytesToHex(confirmationInputs, false));
        byte[] confirmationSalt = SecureUtils.calculateSalt(confirmationInputs);
        MeshLogger.verbose(this.TAG, "Confirmation salt: " + MeshParserUtils.bytesToHex(confirmationSalt, false));
        byte[] ecdhSecret = this.mNode.getSharedECDHSecret();
        byte[] confirmationKey = SecureUtils.calculateK1(ecdhSecret, confirmationSalt, SecureUtils.PRCK);
        MeshLogger.verbose(this.TAG, "Confirmation key: " + MeshParserUtils.bytesToHex(confirmationKey, false));
        byte[] provisionerRandom = SecureUtils.generateRandomNumber();
        this.mNode.setProvisionerRandom(provisionerRandom);
        MeshLogger.verbose(this.TAG, "Provisioner random: " + MeshParserUtils.bytesToHex(provisionerRandom, false));
        byte[] authenticationValue = this.generateAuthenticationValue();
        if (authenticationValue == null) {
            throw new IllegalArgumentException("Invalid authentication value!");
        }
        this.mNode.setAuthenticationValue(authenticationValue);
        MeshLogger.verbose(this.TAG, "Authentication value: " + MeshParserUtils.bytesToHex(authenticationValue, false));
        ByteBuffer buffer = ByteBuffer.allocate(provisionerRandom.length + 16);
        buffer.put(provisionerRandom);
        buffer.put(authenticationValue);
        byte[] confirmationData = buffer.array();
        byte[] confirmationValue = SecureUtils.calculateCMAC(confirmationData, confirmationKey);
        buffer = ByteBuffer.allocate(confirmationValue.length + 2);
        buffer.put(new byte[]{3, 5});
        buffer.put(confirmationValue);
        byte[] provisioningConfirmationPDU = buffer.array();
        MeshLogger.verbose(this.TAG, "Provisioning confirmation: " + MeshParserUtils.bytesToHex(provisioningConfirmationPDU, false));
        return provisioningConfirmationPDU;
    }

    private byte[] generateAuthenticationValue() {
        switch (this.mNode.authMethodUsed) {
            case NO_OOB_AUTHENTICATION: {
                return NO_OOB_AUTH;
            }
            case STATIC_OOB_AUTHENTICATION: {
                return MeshParserUtils.toByteArray(this.authentication);
            }
            case OUTPUT_OOB_AUTHENTICATION: {
                OutputOOBAction action = OutputOOBAction.fromValue(this.mNode.getAuthActionUsed());
                return OutputOOBAction.generateOutputOOBAuthenticationValue(action, this.authentication);
            }
            case INPUT_OOB_AUTHENTICATION: {
                InputOOBAction inputOOBAction = InputOOBAction.fromValue(this.mNode.getAuthActionUsed());
                return InputOOBAction.generateInputOOBAuthenticationValue(inputOOBAction, this.mNode.getInputAuthentication());
            }
        }
        return null;
    }

    private void parseProvisioneeConfirmation(byte[] provisioneeConfirmation) {
        ByteBuffer buffer = ByteBuffer.allocate(provisioneeConfirmation.length - 2);
        buffer.put(provisioneeConfirmation, 2, buffer.limit());
        this.mNode.setProvisioneeConfirmation(buffer.array());
    }
}

