/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.sensorutils;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import no.nordicsemi.android.mesh.sensorutils.DevicePropertyCharacteristic;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;

public class ElectricCurrent
extends DevicePropertyCharacteristic<Float> {
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public ElectricCurrent(@NonNull byte[] data, int offset) {
        super(data, offset);
        int bits = MeshParserUtils.unsignedBytesToInt(data[offset], data[offset + 1]);
        this.value = bits == 65535 ? null : Float.valueOf((float)bits / 100.0f);
    }

    public ElectricCurrent(float current) {
        this.value = Float.valueOf(current);
    }

    @NonNull
    public String toString() {
        return this.value + " A";
    }

    @Override
    public int getLength() {
        return 2;
    }

    @Override
    public byte[] getBytes() {
        byte[] bytes = new byte[]{-1, -1};
        if (this.value != null) {
            int bits = (int)(((Float)this.value).floatValue() * 100.0f + 0.5f);
            for (int n = 0; n < 2; ++n) {
                bytes[n] = (byte)(bits >> n * 8 & 0xFF);
            }
        }
        return bytes;
    }
}

