/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import androidx.annotation.NonNull;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import no.nordicsemi.android.mesh.Features;
import no.nordicsemi.android.mesh.logger.MeshLogger;
import no.nordicsemi.android.mesh.transport.ConfigMessage;
import no.nordicsemi.android.mesh.utils.Heartbeat;
import no.nordicsemi.android.mesh.utils.MeshAddress;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;

public class ConfigHeartbeatPublicationSet
extends ConfigMessage {
    private static final String TAG = ConfigHeartbeatPublicationSet.class.getSimpleName();
    private static final int OP_CODE = 32825;
    private final int dstAddress;
    private byte countLog;
    private byte periodLog;
    private final int ttl;
    private final Features features;
    private final int netKeyIndex;

    public ConfigHeartbeatPublicationSet() throws IllegalArgumentException {
        this(0, 0, 0, 0, new Features(2, 2, 2, 2), 0);
    }

    public ConfigHeartbeatPublicationSet(int dstAddress, byte countLog, byte periodLog, int ttl, @NonNull Features features, int netKeyIndex) throws IllegalArgumentException {
        if (!MeshAddress.isValidHeartbeatPublicationDestination(dstAddress)) {
            throw new IllegalArgumentException("Destination address must be an unassigned address, a unicast address, or a group address, all other values are Prohibited!");
        }
        this.dstAddress = dstAddress;
        if (MeshParserUtils.isValidHeartbeatCountLog(countLog)) {
            this.countLog = countLog;
        }
        if (Heartbeat.isValidHeartbeatPeriodLog(periodLog)) {
            this.periodLog = periodLog;
        }
        if (!MeshParserUtils.isValidHeartbeatPublicationTtl(ttl)) {
            throw new IllegalArgumentException("Heartbeat ttl must be within the range of 0x00 to 0x7F!");
        }
        this.ttl = ttl;
        this.features = features;
        this.netKeyIndex = netKeyIndex;
        this.assembleMessageParameters();
    }

    @Override
    public int getOpCode() {
        return 32825;
    }

    @Override
    void assembleMessageParameters() {
        MeshLogger.debug(TAG, "Destination address: " + Integer.toHexString(this.dstAddress));
        MeshLogger.debug(TAG, "Count Log: " + Integer.toHexString(this.countLog));
        MeshLogger.debug(TAG, "Period Log: " + Integer.toHexString(this.periodLog));
        MeshLogger.debug(TAG, "TTL: " + Integer.toHexString(this.dstAddress));
        MeshLogger.debug(TAG, "Features: " + this.features.toString());
        MeshLogger.debug(TAG, "Net key index: " + Integer.toHexString(this.netKeyIndex));
        byte[] netKeyIndex = MeshParserUtils.addKeyIndexPadding(this.netKeyIndex);
        ByteBuffer paramsBuffer = ByteBuffer.allocate(9).order(ByteOrder.LITTLE_ENDIAN);
        paramsBuffer.putShort((short)this.dstAddress);
        paramsBuffer.put(this.countLog);
        paramsBuffer.put(this.periodLog);
        paramsBuffer.put((byte)this.ttl);
        paramsBuffer.putShort((short)this.features.assembleFeatures());
        paramsBuffer.put(netKeyIndex[1]);
        paramsBuffer.put((byte)(netKeyIndex[0] & 0xFF & 0xF));
        this.mParameters = paramsBuffer.array();
    }
}

