/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import java.util.ArrayList;
import java.util.List;
import no.nordicsemi.android.mesh.logger.MeshLogger;
import no.nordicsemi.android.mesh.transport.AccessMessage;
import no.nordicsemi.android.mesh.transport.ConfigStatusMessage;

public class ConfigNetKeyList
extends ConfigStatusMessage
implements Parcelable {
    private static final String TAG = ConfigNetKeyList.class.getSimpleName();
    private static final int OP_CODE = 32835;
    private final List<Integer> mKeyIndexes = new ArrayList<Integer>();
    public static final Parcelable.Creator<ConfigNetKeyList> CREATOR = new Parcelable.Creator<ConfigNetKeyList>(){

        public ConfigNetKeyList createFromParcel(Parcel in) {
            AccessMessage message = (AccessMessage)in.readParcelable(AccessMessage.class.getClassLoader());
            return new ConfigNetKeyList(message);
        }

        public ConfigNetKeyList[] newArray(int size) {
            return new ConfigNetKeyList[size];
        }
    };

    public ConfigNetKeyList(@NonNull AccessMessage message) {
        super(message);
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    @Override
    final void parseStatusParameters() {
        this.mKeyIndexes.addAll(this.decode(this.mParameters.length, 0));
        for (Integer keyIndex : this.mKeyIndexes) {
            MeshLogger.verbose(TAG, "Key Index: " + Integer.toHexString(keyIndex));
        }
    }

    @Override
    public final int getOpCode() {
        return 32835;
    }

    public final boolean isSuccessful() {
        return this.mStatusCode == 0;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        AccessMessage message = (AccessMessage)this.mMessage;
        dest.writeParcelable((Parcelable)message, flags);
    }

    public List<Integer> getKeyIndexes() {
        return this.mKeyIndexes;
    }
}

