/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import androidx.annotation.NonNull;
import no.nordicsemi.android.mesh.ApplicationKey;
import no.nordicsemi.android.mesh.MeshTAITime;
import no.nordicsemi.android.mesh.transport.ApplicationMessage;
import no.nordicsemi.android.mesh.utils.ArrayUtils;
import no.nordicsemi.android.mesh.utils.BitWriter;
import no.nordicsemi.android.mesh.utils.SecureUtils;

public class TimeSet
extends ApplicationMessage {
    private final MeshTAITime taiTime;

    public TimeSet(@NonNull ApplicationKey appKey, MeshTAITime taiTime) {
        super(appKey);
        this.taiTime = taiTime;
        this.assembleMessageParameters();
    }

    @Override
    void assembleMessageParameters() {
        this.mAid = SecureUtils.calculateK4(this.mAppKey.getKey());
        BitWriter bitWriter = new BitWriter(80);
        bitWriter.write(this.taiTime.getTimeZoneOffset() + 64, 8);
        bitWriter.write(this.taiTime.getUtcDelta() + 255, 15);
        if (this.taiTime.isTimeAuthority()) {
            bitWriter.write(1, 1);
        } else {
            bitWriter.write(0, 1);
        }
        bitWriter.write(this.taiTime.getUncertainty(), 8);
        bitWriter.write(this.taiTime.getSubSecond(), 8);
        bitWriter.write(this.taiTime.getTaiSeconds(), 40);
        this.mParameters = ArrayUtils.reverseArray(bitWriter.toByteArray());
    }

    @Override
    public int getOpCode() {
        return 92;
    }
}

