/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.utils;

import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class RelaySettings
implements Parcelable {
    public static final int RELAY_FEATURE_DISABLED = 0;
    public static final int RELAY_FEATURE_ENABLED = 1;
    public static final int RELAY_FEATURE_NOT_SUPPORTED = 2;
    private final int relayTransmitCount;
    private final int relayIntervalSteps;
    public static final Parcelable.Creator<RelaySettings> CREATOR = new Parcelable.Creator<RelaySettings>(){

        public RelaySettings createFromParcel(Parcel in) {
            return new RelaySettings(in);
        }

        public RelaySettings[] newArray(int size) {
            return new RelaySettings[size];
        }
    };

    public RelaySettings(int relayTransmitCount, int relayIntervalSteps) {
        this.relayTransmitCount = relayTransmitCount;
        this.relayIntervalSteps = relayIntervalSteps;
    }

    protected RelaySettings(Parcel in) {
        this.relayTransmitCount = in.readInt();
        this.relayIntervalSteps = in.readInt();
    }

    public static boolean isRelaySupported(int relay) {
        switch (relay) {
            case 0: 
            case 1: {
                return true;
            }
        }
        return false;
    }

    public static boolean isRelayEnabled(int relay) {
        return relay == 1;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.relayTransmitCount);
        dest.writeInt(this.relayIntervalSteps);
    }

    public int describeContents() {
        return 0;
    }

    public int getRelayTransmitCount() {
        return this.relayTransmitCount;
    }

    public int getTotalTransmissionsCount() {
        return this.relayTransmitCount + 1;
    }

    public int getRelayIntervalSteps() {
        return this.relayIntervalSteps;
    }

    public int getRetransmissionIntervals() {
        return (this.relayIntervalSteps + 1) * 10;
    }

    public static int decodeRelayRetransmitInterval(int interval) {
        if (interval >= 10 && interval <= 320 && interval % 10 != 0) {
            throw new IllegalArgumentException("Relay Retransmit Interval must be in range of 10-320 ms.");
        }
        return interval / 10 - 1;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RelayState {
    }
}

