/*
 * Decompiled with CFR 0.152.
 */
package no.sirktek.taxonomy;

import java.util.List;
import java.util.Optional;
import lombok.Generated;
import no.sirktek.taxonomy.loader.RdfsTaxonomyLoader;
import no.sirktek.taxonomy.model.CategoryInfo;
import no.sirktek.taxonomy.model.TaxonomyTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaxonomyService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaxonomyService.class);
    private final RdfsTaxonomyLoader loader;
    private volatile TaxonomyTree cachedTaxonomy;

    public TaxonomyService(RdfsTaxonomyLoader loader) {
        this.loader = loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaxonomyTree loadBaseTaxonomy() {
        if (this.cachedTaxonomy == null) {
            TaxonomyService taxonomyService = this;
            synchronized (taxonomyService) {
                if (this.cachedTaxonomy == null) {
                    log.info("Loading base taxonomy from RDF-S for the first time");
                    this.cachedTaxonomy = this.loader.loadBaseTaxonomy();
                }
            }
        }
        return this.cachedTaxonomy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaxonomyTree reloadBaseTaxonomy() {
        TaxonomyService taxonomyService = this;
        synchronized (taxonomyService) {
            log.info("Forcing reload of base taxonomy");
            this.cachedTaxonomy = null;
            return this.loadBaseTaxonomy();
        }
    }

    public Optional<CategoryInfo> getCategoryByClassName(String className) {
        if (className == null) {
            return Optional.empty();
        }
        TaxonomyTree taxonomy = this.loadBaseTaxonomy();
        CategoryInfo found = taxonomy.findByClassName(className);
        return Optional.ofNullable(found);
    }

    public boolean isBaseTaxonomyClass(String className) {
        return this.getCategoryByClassName(className).isPresent();
    }

    public TaxonomyStats getStats() {
        TaxonomyTree taxonomy = this.loadBaseTaxonomy();
        int totalCategories = this.countCategoriesRecursively(taxonomy.rootCategories());
        int rootCategories = taxonomy.rootCategories().size();
        return TaxonomyStats.builder().totalCategories(totalCategories).rootCategories(rootCategories).build();
    }

    private int countCategoriesRecursively(List<CategoryInfo> categories) {
        int count = categories.size();
        for (CategoryInfo category : categories) {
            count += this.countCategoriesRecursively(category.children());
        }
        return count;
    }

    public record TaxonomyStats(int totalCategories, int rootCategories) {
        @Generated
        public static TaxonomyStatsBuilder builder() {
            return new TaxonomyStatsBuilder();
        }

        @Generated
        public static class TaxonomyStatsBuilder {
            @Generated
            private int totalCategories;
            @Generated
            private int rootCategories;

            @Generated
            TaxonomyStatsBuilder() {
            }

            @Generated
            public TaxonomyStatsBuilder totalCategories(int totalCategories) {
                this.totalCategories = totalCategories;
                return this;
            }

            @Generated
            public TaxonomyStatsBuilder rootCategories(int rootCategories) {
                this.rootCategories = rootCategories;
                return this;
            }

            @Generated
            public TaxonomyStats build() {
                return new TaxonomyStats(this.totalCategories, this.rootCategories);
            }

            @Generated
            public String toString() {
                return "TaxonomyService.TaxonomyStats.TaxonomyStatsBuilder(totalCategories=" + this.totalCategories + ", rootCategories=" + this.rootCategories + ")";
            }
        }
    }
}

