/*
 * Decompiled with CFR 0.152.
 */
package no.sirktek.taxonomy.loader;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import no.sirktek.taxonomy.model.CategoryInfo;
import no.sirktek.taxonomy.model.PropertyDefinition;
import no.sirktek.taxonomy.model.TaxonomyTree;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RdfsTaxonomyLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RdfsTaxonomyLoader.class);

    protected abstract String getNamespace();

    protected abstract String getResourcePath();

    public TaxonomyTree loadBaseTaxonomy() {
        return this.loadTaxonomyFromResource(this.getResourcePath());
    }

    public TaxonomyTree loadTaxonomyFromResource(String resourcePath) {
        TaxonomyTree taxonomyTree;
        block9: {
            log.debug("Loading taxonomy from resource: {}", (Object)resourcePath);
            InputStream inputStream = this.getClass().getResourceAsStream(resourcePath);
            try {
                if (inputStream == null) {
                    throw new TaxonomyLoadException("Could not find resource: " + resourcePath);
                }
                Model model = ModelFactory.createDefaultModel();
                model.read(inputStream, null, "TURTLE");
                taxonomyTree = this.buildTaxonomyTree(model);
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new TaxonomyLoadException("Failed to load taxonomy from " + resourcePath, e);
                }
            }
            inputStream.close();
        }
        return taxonomyTree;
    }

    private TaxonomyTree buildTaxonomyTree(Model model) {
        log.debug("Building taxonomy tree from RDF model");
        String namespace = this.getNamespace();
        HashMap<String, CategoryInfo> allCategories = new HashMap<String, CategoryInfo>();
        HashMap<String, List<String>> parentChildMap = new HashMap<String, List<String>>();
        ResIterator classIterator = model.listSubjectsWithProperty(RDF.type, (RDFNode)RDFS.Class);
        while (classIterator.hasNext()) {
            Resource classResource = classIterator.nextResource();
            if (classResource.getURI() == null || !classResource.getURI().startsWith(namespace)) continue;
            CategoryInfo categoryInfo = this.buildCategoryInfo(classResource, model, namespace);
            allCategories.put(categoryInfo.className(), categoryInfo);
            if (categoryInfo.parentClassName() == null) continue;
            parentChildMap.computeIfAbsent(categoryInfo.parentClassName(), k -> new ArrayList()).add(categoryInfo.className());
        }
        Map<String, CategoryInfo> categoriesWithChildren = this.buildHierarchy(allCategories, parentChildMap);
        List<CategoryInfo> rootCategories = categoriesWithChildren.values().stream().filter(CategoryInfo::isRoot).sorted(Comparator.comparing(CategoryInfo::englishName)).collect(Collectors.toList());
        log.info("Loaded taxonomy with {} total categories, {} root categories", (Object)allCategories.size(), (Object)rootCategories.size());
        return TaxonomyTree.builder().rootCategories(rootCategories).build();
    }

    private Map<String, CategoryInfo> buildHierarchy(Map<String, CategoryInfo> allCategories, Map<String, List<String>> parentChildMap) {
        HashMap<String, CategoryInfo> categoriesWithChildren = new HashMap<String, CategoryInfo>();
        for (CategoryInfo category : allCategories.values()) {
            categoriesWithChildren.put(category.className(), category);
        }
        for (CategoryInfo category : allCategories.values()) {
            CategoryInfo categoryWithChildren = this.buildCategoryWithChildren(category, allCategories, parentChildMap);
            categoriesWithChildren.put(category.className(), categoryWithChildren);
        }
        return categoriesWithChildren;
    }

    private CategoryInfo buildCategoryWithChildren(CategoryInfo category, Map<String, CategoryInfo> allCategories, Map<String, List<String>> parentChildMap) {
        List childClassNames = parentChildMap.getOrDefault(category.className(), Collections.emptyList());
        ArrayList<CategoryInfo> children = new ArrayList<CategoryInfo>();
        for (String childClassName : childClassNames) {
            CategoryInfo childCategory = allCategories.get(childClassName);
            if (childCategory == null) continue;
            CategoryInfo childWithChildren = this.buildCategoryWithChildren(childCategory, allCategories, parentChildMap);
            children.add(childWithChildren);
        }
        children.sort(Comparator.comparing(CategoryInfo::englishName));
        return CategoryInfo.builder().className(category.className()).englishName(category.englishName()).norwegianName(category.norwegianName()).description(category.description()).parentClassName(category.parentClassName()).uri(category.uri()).properties(category.properties()).children(children).build();
    }

    private CategoryInfo buildCategoryInfo(Resource classResource, Model model, String namespace) {
        String uri = classResource.getURI();
        String className = this.getLocalName(uri);
        String englishName = this.getLabel(classResource, "en");
        String norwegianName = this.getLabel(classResource, "no");
        if (englishName == null) {
            englishName = className;
        }
        String description = null;
        Statement commentStmt = classResource.getProperty(RDFS.comment);
        if (commentStmt != null) {
            description = commentStmt.getString();
        }
        String parentClassName = null;
        StmtIterator subClassStatements = classResource.listProperties(RDFS.subClassOf);
        while (subClassStatements.hasNext()) {
            Statement stmt = subClassStatements.nextStatement();
            Resource parentResource = stmt.getResource();
            if (parentResource.getURI() == null || !parentResource.getURI().startsWith(namespace)) continue;
            parentClassName = this.getLocalName(parentResource.getURI());
            break;
        }
        List<PropertyDefinition> properties = this.getPropertiesForClass(classResource, model, namespace);
        return CategoryInfo.builder().className(className).englishName(englishName).norwegianName(norwegianName).description(description).parentClassName(parentClassName).uri(uri).properties(properties).children(Collections.emptyList()).build();
    }

    private String getLabel(Resource resource, String language) {
        StmtIterator labelStatements = resource.listProperties(RDFS.label);
        while (labelStatements.hasNext()) {
            Statement stmt = labelStatements.nextStatement();
            Literal literal = stmt.getLiteral();
            if (literal == null || !language.equals(literal.getLanguage())) continue;
            return literal.getString();
        }
        return null;
    }

    private List<PropertyDefinition> getPropertiesForClass(Resource classResource, Model model, String namespace) {
        ArrayList<PropertyDefinition> properties = new ArrayList<PropertyDefinition>();
        String classUri = classResource.getURI();
        ResIterator propertyIterator = model.listSubjectsWithProperty(RDF.type, (RDFNode)RDF.Property);
        while (propertyIterator.hasNext()) {
            Resource propertyResource = propertyIterator.nextResource();
            if (propertyResource.getURI() == null || !propertyResource.getURI().startsWith(namespace) || !this.hasDomain(propertyResource, classUri)) continue;
            PropertyDefinition propertyDef = this.buildPropertyDefinition(propertyResource);
            properties.add(propertyDef);
        }
        return properties;
    }

    private boolean hasDomain(Resource propertyResource, String classUri) {
        StmtIterator domainStatements = propertyResource.listProperties(RDFS.domain);
        while (domainStatements.hasNext()) {
            Statement stmt = domainStatements.nextStatement();
            Resource domainResource = stmt.getResource();
            if (!classUri.equals(domainResource.getURI())) continue;
            return true;
        }
        return false;
    }

    private PropertyDefinition buildPropertyDefinition(Resource propertyResource) {
        String uri = propertyResource.getURI();
        String name = this.getLocalName(uri);
        String englishLabel = this.getLabel(propertyResource, "en");
        String norwegianLabel = this.getLabel(propertyResource, "no");
        String rangeType = null;
        Statement rangeStmt = propertyResource.getProperty(RDFS.range);
        if (rangeStmt != null) {
            rangeType = rangeStmt.getResource().getURI();
        }
        String domainClass = null;
        Statement domainStmt = propertyResource.getProperty(RDFS.domain);
        if (domainStmt != null) {
            domainClass = this.getLocalName(domainStmt.getResource().getURI());
        }
        return PropertyDefinition.builder().name(name).englishLabel(englishLabel).norwegianLabel(norwegianLabel).uri(uri).rangeType(rangeType).domainClass(domainClass).description(null).build();
    }

    private String getLocalName(String uri) {
        if (uri == null) {
            return null;
        }
        int hashIndex = uri.lastIndexOf(35);
        if (hashIndex >= 0) {
            return uri.substring(hashIndex + 1);
        }
        int slashIndex = uri.lastIndexOf(47);
        if (slashIndex >= 0) {
            return uri.substring(slashIndex + 1);
        }
        return uri;
    }

    public static class TaxonomyLoadException
    extends RuntimeException {
        public TaxonomyLoadException(String message) {
            super(message);
        }

        public TaxonomyLoadException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

