/*
 * Decompiled with CFR 0.152.
 */
package no.sirktek.taxonomy.model;

import java.util.List;
import lombok.Generated;
import no.sirktek.taxonomy.model.CategoryInfo;

public record TaxonomyTree(List<CategoryInfo> rootCategories) {
    public CategoryInfo findByClassName(String className) {
        return this.findCategoryRecursively(this.rootCategories, className);
    }

    private CategoryInfo findCategoryRecursively(List<CategoryInfo> categories, String className) {
        for (CategoryInfo category : categories) {
            if (category.className().equals(className)) {
                return category;
            }
            CategoryInfo found = this.findCategoryRecursively(category.children(), className);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    @Generated
    public static TaxonomyTreeBuilder builder() {
        return new TaxonomyTreeBuilder();
    }

    @Generated
    public static class TaxonomyTreeBuilder {
        @Generated
        private List<CategoryInfo> rootCategories;

        @Generated
        TaxonomyTreeBuilder() {
        }

        @Generated
        public TaxonomyTreeBuilder rootCategories(List<CategoryInfo> rootCategories) {
            this.rootCategories = rootCategories;
            return this;
        }

        @Generated
        public TaxonomyTree build() {
            return new TaxonomyTree(this.rootCategories);
        }

        @Generated
        public String toString() {
            return "TaxonomyTree.TaxonomyTreeBuilder(rootCategories=" + String.valueOf(this.rootCategories) + ")";
        }
    }
}

