/*
 * Decompiled with CFR 0.152.
 */
package no.sparebank1.turbo;

import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;

public class TurboConfig {
    static final String M2_REPOSITORY_PATH_ON_BUILDSERVER = "/var/cache/maven_repository";
    public final boolean enabled;
    public final String ignoreChangesInFiles;
    public final String alwaysBuildModules;
    public final String m2Repository;

    public TurboConfig(MavenSession session) {
        Plugin plugin = session.getTopLevelProject().getPlugin("no.sparebank1:turbo-maven-plugin");
        String configAsXml = plugin.getConfiguration() != null ? plugin.getConfiguration().toString() : "";
        this.ignoreChangesInFiles = TurboConfig.getParameter(configAsXml, "ignoreChangesInFiles", "");
        this.alwaysBuildModules = TurboConfig.getParameter(configAsXml, "alwaysBuildModules", "");
        this.m2Repository = session.getLocalRepository().getBasedir();
        List goals = session.getGoals();
        this.enabled = TurboConfig.shallNotRun(this.m2Repository, goals) ? false : Boolean.valueOf(TurboConfig.getParameter(configAsXml, "enabled", "true"));
    }

    static boolean shallNotRun(String m2Repository, List<String> goals) {
        if (TurboConfig.isThisBuildRunningOnTheBuildServer(m2Repository)) {
            return true;
        }
        return TurboConfig.isThisBuildCallingAPlugin(goals);
    }

    private static boolean isThisBuildCallingAPlugin(List<String> goals) {
        boolean isCallingAPlugin = goals.stream().filter(g -> g.contains(":")).count() > 0L;
        return isCallingAPlugin;
    }

    private static boolean isThisBuildRunningOnTheBuildServer(String m2Repository) {
        return m2Repository.equals(M2_REPOSITORY_PATH_ON_BUILDSERVER);
    }

    static String getParameter(String configAsXml, String paramName, String defaultValue) {
        Optional<String> paramFromConfig = TurboConfig.xmlToStringValue(configAsXml, paramName);
        return TurboConfig.getParamFromCommandLine("turbo." + paramName).orElse(paramFromConfig.orElse(defaultValue));
    }

    static Optional<String> getParamFromCommandLine(String paramName) {
        return Optional.ofNullable(System.getProperty(paramName));
    }

    static Optional<String> xmlToStringValue(String configAsXml, String paramname) {
        String pattern = "<" + paramname + ">(.*)</" + paramname + ">";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(configAsXml);
        if (m.find()) {
            return Optional.of(m.group(1));
        }
        return Optional.empty();
    }
}

