/*
 * Decompiled with CFR 0.152.
 */
package tornadofx.control;

import javafx.beans.DefaultProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Skin;
import javafx.scene.layout.HBox;
import tornadofx.control.Fieldset;
import tornadofx.control.skin.FieldSkin;

@DefaultProperty(value="inputs")
public class Field
extends Control {
    private SimpleStringProperty textProperty = new SimpleStringProperty();
    private Label label = new Label();
    private LabelContainer labelContainer = new LabelContainer(this.label);
    private InputContainer inputContainer = new InputContainer();
    private ObservableList<Node> inputs;

    public LabelContainer getLabelContainer() {
        return this.labelContainer;
    }

    public Field(String text, Node ... inputs) {
        this();
        this.setText(text);
        if (inputs != null) {
            this.getInputContainer().getChildren().addAll((Object[])inputs);
        }
    }

    public Field() {
        this.setFocusTraversable(false);
        this.getStyleClass().add((Object)"field");
        this.label.textProperty().bind((ObservableValue)this.textProperty);
        this.inputs = this.inputContainer.getChildren();
        this.getChildren().addAll((Object[])new Node[]{this.labelContainer, this.inputContainer});
    }

    public Fieldset getFieldset() {
        return (Fieldset)this.getParent();
    }

    protected Skin<?> createDefaultSkin() {
        return new FieldSkin(this);
    }

    public InputContainer getInputContainer() {
        return this.inputContainer;
    }

    public ObservableList<Node> getInputs() {
        return this.inputs;
    }

    public void setInputs(ObservableList<Node> inputs) {
        this.inputs = inputs;
    }

    public String getText() {
        return this.textProperty.get();
    }

    public SimpleStringProperty textProperty() {
        return this.textProperty;
    }

    public void setText(String text) {
        this.textProperty.set(text);
    }

    public class InputContainer
    extends HBox {
        public InputContainer() {
            this.getStyleClass().add((Object)"input-container");
        }
    }

    public class LabelContainer
    extends HBox {
        public LabelContainer(Label label) {
            this.getChildren().add((Object)label);
            this.getStyleClass().add((Object)"label-container");
        }
    }
}

