/*
 * Decompiled with CFR 0.152.
 */
package tornadofx.control;

import java.util.stream.Stream;
import javafx.beans.DefaultProperty;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import tornadofx.control.Field;
import tornadofx.control.Form;

@DefaultProperty(value="children")
public class Fieldset
extends VBox {
    private static final PseudoClass HORIZONTAL_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"horizontal");
    private static final PseudoClass VERTICAL_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"vertical");
    private SimpleStringProperty text = new SimpleStringProperty();
    private ObjectProperty<Priority> inputGrow = new SimpleObjectProperty((Object)Priority.SOMETIMES);
    private ObjectProperty<Orientation> orientation = new SimpleObjectProperty();
    private ObjectProperty<Double> wrapWidth = new SimpleObjectProperty();
    private ObjectProperty<Node> icon = new SimpleObjectProperty();
    private Label legend;

    public Fieldset(String text) {
        this();
        this.setText(text);
    }

    public Field field(String text, Node ... inputs) {
        Field field = new Field(text, inputs);
        this.getChildren().add((Object)field);
        return field;
    }

    public Field field() {
        Field field = new Field();
        this.getChildren().add((Object)field);
        return field;
    }

    public Field field(Node ... inputs) {
        Field field = new Field(null, inputs);
        this.getChildren().add((Object)field);
        return field;
    }

    public Fieldset() {
        this.getStyleClass().add((Object)"fieldset");
        this.syncOrientationState();
        this.textProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                this.addLegend();
            }
        });
        this.iconProperty().addListener((observable1, oldValue1, newValue) -> {
            if (newValue != null) {
                this.addLegend();
            }
        });
        this.getChildren().addListener(c -> {
            while (c.next()) {
                if (!c.wasAdded()) continue;
                c.getAddedSubList().stream().filter(added -> added instanceof Field).forEach(added -> {
                    Field field = (Field)((Object)((Object)added));
                    field.getInputContainer().getChildren().forEach(this::configureHgrow);
                    field.getInputContainer().getChildren().addListener(c1 -> {
                        while (c1.next()) {
                            if (!c1.wasAdded()) continue;
                            c1.getAddedSubList().forEach(this::configureHgrow);
                        }
                    });
                });
            }
        });
        this.inputGrowProperty().addListener((observable, oldValue, newValue) -> this.getChildren().stream().filter(c -> c instanceof Field).forEach(c -> {
            Field field = (Field)((Object)((Object)c));
            field.getInputContainer().getChildren().forEach(this::configureHgrow);
        }));
        this.setOrientation(Orientation.HORIZONTAL);
    }

    private void syncOrientationState() {
        this.orientation.addListener((observable, oldValue, newValue) -> {
            if (newValue == Orientation.HORIZONTAL) {
                this.pseudoClassStateChanged(VERTICAL_PSEUDOCLASS_STATE, false);
                this.pseudoClassStateChanged(HORIZONTAL_PSEUDOCLASS_STATE, true);
            } else {
                this.pseudoClassStateChanged(HORIZONTAL_PSEUDOCLASS_STATE, false);
                this.pseudoClassStateChanged(VERTICAL_PSEUDOCLASS_STATE, true);
            }
        });
        this.wrapWidth.addListener((observable, oldValue, newValue) -> {
            ObjectBinding responsiveOrientation = Bindings.createObjectBinding(() -> this.getWidth() < newValue ? Orientation.VERTICAL : Orientation.HORIZONTAL, (Observable[])new Observable[]{this.widthProperty()});
            if (this.orientationProperty().isBound()) {
                this.orientationProperty().unbind();
            }
            this.orientationProperty().bind((ObservableValue)responsiveOrientation);
        });
    }

    private void addLegend() {
        if (this.legend == null) {
            this.legend = new Label();
            this.legend.textProperty().bind((ObservableValue)this.textProperty());
            this.legend.getStyleClass().add((Object)"legend");
            this.getChildren().add(0, (Object)this.legend);
        }
        this.legend.setGraphic(this.getIcon());
    }

    private void configureHgrow(Node input) {
        HBox.setHgrow((Node)input, (Priority)this.getInputGrow());
    }

    public Form getForm() {
        return (Form)this.getParent();
    }

    Stream<Field> getFields() {
        return this.getChildren().stream().filter(c -> c instanceof Field).map(c -> (Field)((Object)c));
    }

    public Priority getInputGrow() {
        return (Priority)this.inputGrow.get();
    }

    public ObjectProperty<Priority> inputGrowProperty() {
        return this.inputGrow;
    }

    public void setInputGrow(Priority inputGrow) {
        this.inputGrow.set((Object)inputGrow);
    }

    public String getText() {
        return this.text.get();
    }

    public SimpleStringProperty textProperty() {
        return this.text;
    }

    public void setText(String text) {
        this.text.set(text);
    }

    public Orientation getOrientation() {
        return (Orientation)this.orientation.get();
    }

    public ObjectProperty<Orientation> orientationProperty() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation.set((Object)orientation);
    }

    public Double getWrapWidth() {
        return (Double)this.wrapWidth.get();
    }

    public ObjectProperty<Double> wrapWidthProperty() {
        return this.wrapWidth;
    }

    public void setWrapWidth(Double wrapWidth) {
        this.wrapWidth.set((Object)wrapWidth);
    }

    public Node getIcon() {
        return (Node)this.icon.get();
    }

    public ObjectProperty<Node> iconProperty() {
        return this.icon;
    }

    public void setIcon(Node icon) {
        this.icon.set((Object)icon);
    }
}

