/*
 * Decompiled with CFR 0.152.
 */
package tornadofx.control;

import java.util.function.Function;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import tornadofx.control.ListMenu;

public class NaviSelect<T>
extends HBox {
    private Button editButton = new Button();
    private TextField visual = new TextField();
    private Button gotoButton = new Button();
    private Function<T, String> defaultVisualConverter = t -> {
        String value = t == null ? null : t.toString();
        return value == null ? "" : value;
    };
    private ObjectProperty<Function<T, String>> visualConverter = new SimpleObjectProperty<Function<T, String>>(this.defaultVisualConverter){

        public void set(Function<T, String> newValue) {
            super.set(newValue);
            NaviSelect.this.visualBinding.invalidate();
        }
    };
    private ObjectProperty<T> value = new SimpleObjectProperty();
    private StringBinding visualBinding = Bindings.createStringBinding(() -> this.getVisualConverter().apply(this.getValue()), (Observable[])new Observable[]{this.valueProperty()});

    public NaviSelect() {
        this.getStyleClass().add((Object)"navi-select");
        this.visual.getStyleClass().add((Object)"visual");
        this.visual.textProperty().bind((ObservableValue)this.visualBinding);
        HBox.setHgrow((Node)this.visual, (Priority)Priority.ALWAYS);
        Pane editButtonGraphic = new Pane();
        editButtonGraphic.getStyleClass().add((Object)"icon");
        this.editButton.setGraphic((Node)editButtonGraphic);
        this.editButton.setTooltip(new Tooltip("Edit"));
        Pane gotoButtonGraphic = new Pane();
        gotoButtonGraphic.getStyleClass().add((Object)"icon");
        this.gotoButton.setGraphic((Node)gotoButtonGraphic);
        this.gotoButton.setTooltip(new Tooltip("Goto"));
        this.editButton.getStyleClass().add((Object)"edit-button");
        this.gotoButton.getStyleClass().add((Object)"goto-button");
        this.getChildren().addAll((Object[])new Node[]{this.visual, this.editButton, this.gotoButton});
    }

    public void setOnEdit(EventHandler<ActionEvent> editHandler) {
        this.editButton.setOnAction(editHandler);
    }

    public void setOnGoto(EventHandler<ActionEvent> gotoHandler) {
        this.gotoButton.setOnAction(gotoHandler);
    }

    public ObjectProperty<T> valueProperty() {
        return this.value;
    }

    public T getValue() {
        return (T)this.value.get();
    }

    public void setValue(T value) {
        this.value.set(value);
    }

    public TextField getVisual() {
        return this.visual;
    }

    public void setVisual(TextField visual) {
        this.visual = visual;
    }

    public Button getEditButton() {
        return this.editButton;
    }

    public void setEditButton(Button editButton) {
        this.editButton = editButton;
    }

    public Button getGotoButton() {
        return this.gotoButton;
    }

    public void setGotoButton(Button gotoButton) {
        this.gotoButton = gotoButton;
    }

    public String getUserAgentStylesheet() {
        return ListMenu.class.getResource("naviselect.css").toExternalForm();
    }

    public Function<T, String> getVisualConverter() {
        return (Function)this.visualConverter.get();
    }

    public ObjectProperty<Function<T, String>> visualConverterProperty() {
        return this.visualConverter;
    }

    public void setVisualConverter(Function<T, String> visualConverter) {
        this.visualConverter.set(visualConverter);
    }
}

