/*
 * Decompiled with CFR 0.152.
 */
package tornadofx.control;

import javafx.beans.DefaultProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import tornadofx.control.AbstractField;
import tornadofx.control.Fieldset;
import tornadofx.util.NodeHelper;

@DefaultProperty(value="inputs")
public class Field
extends AbstractField {
    private Pane inputContainer = null;
    private Orientation orientation;

    public Field() {
        this(null);
    }

    public Field(String text) {
        this(text, Orientation.HORIZONTAL);
    }

    public Field(String text, Orientation orientation) {
        this(text, orientation, false, null);
    }

    public Field(String text, Orientation orientation, Node ... inputs) {
        this(text, orientation, false, inputs);
    }

    public Field(String text, Node ... inputs) {
        this(text, Orientation.HORIZONTAL, false, inputs);
    }

    public Field(String text, Orientation orientation, boolean forceLabelIndent, Node ... inputs) {
        super(text, forceLabelIndent);
        this.orientation = orientation;
        this.getStyleClass().add((Object)"field");
        this.parentProperty().addListener((obs, oldParent, newParent) -> {
            Fieldset newFieldSet;
            Fieldset oldFieldSet;
            if (!(oldParent instanceof Fieldset) && (oldFieldSet = NodeHelper.findParentOfType((Node)oldParent, Fieldset.class)) != null) {
                oldFieldSet.getFields().remove((Object)this);
            }
            if (!(newParent instanceof Fieldset) && (newFieldSet = NodeHelper.findParentOfType((Node)newParent, Fieldset.class)) != null) {
                newFieldSet.getFields().add(this);
            }
            this.syncVgrowConstraints();
        });
        this.getChildren().add((Object)this.getInputContainer());
        if (inputs != null) {
            this.getInputs().addAll((Object[])inputs);
        }
        for (Node input : this.getInputs()) {
            this.configureMnemonicTarget(input);
        }
        this.getInputContainer().getChildren().addListener(c1 -> {
            while (c1.next()) {
                if (!c1.wasAdded()) continue;
                c1.getAddedSubList().forEach(node -> {
                    if (VBox.getVgrow((Node)node) != null) {
                        this.syncVgrowConstraints((Node)node);
                    }
                    this.configureMnemonicTarget((Node)node);
                });
            }
        });
    }

    public Fieldset getFieldset() {
        return NodeHelper.findParentOfType((Node)this, Fieldset.class);
    }

    public Pane getInputContainer() {
        if (this.inputContainer == null) {
            this.inputContainer = Orientation.HORIZONTAL.equals((Object)this.orientation) ? new HBox() : new VBox();
            this.inputContainer.getStyleClass().add((Object)"input-container");
            NodeHelper.addPseudoClass((Node)this.inputContainer, this.orientation.name().toLowerCase());
        }
        return this.inputContainer;
    }

    protected void syncVgrowConstraints() {
        this.getInputContainer().getChildren().stream().filter(n -> VBox.getVgrow((Node)n) != null).findFirst().ifPresent(this::syncVgrowConstraints);
    }

    private void syncVgrowConstraints(Node inputNode) {
        Priority priority = VBox.getVgrow((Node)inputNode);
        Field parentField = NodeHelper.findParentOfType(inputNode, Field.class);
        if (parentField != null) {
            VBox.setVgrow((Node)parentField, (Priority)priority);
            if (parentField.getFieldSet() != null) {
                VBox.setVgrow((Node)parentField.getFieldset(), (Priority)priority);
            }
        }
    }

    public void configureHGrow(Priority priority) {
        this.getInputContainer().getChildren().forEach(node -> HBox.setHgrow((Node)node, (Priority)priority));
        this.getInputContainer().getChildren().addListener(c1 -> {
            while (c1.next()) {
                if (!c1.wasAdded()) continue;
                c1.getAddedSubList().forEach(node -> {
                    HBox.setHgrow((Node)node, (Priority)priority);
                    this.syncVgrowConstraints((Node)node);
                });
            }
        });
    }

    private void configureMnemonicTarget(Node target) {
        if (target.getProperties().containsKey((Object)"mnemonicTarget")) {
            this.getLabel().setMnemonicParsing(true);
            this.getLabel().setLabelFor(target);
        }
    }

    public static void setMnemonicTarget(Node target) {
        Field parent = NodeHelper.findParentOfType(target, Field.class);
        if (parent != null) {
            parent.getLabel().setMnemonicParsing(true);
            parent.getLabel().setLabelFor(target);
        } else {
            target.getProperties().put((Object)"mnemonicTarget", (Object)Boolean.TRUE);
        }
    }

    @Override
    public ObservableList<Node> getInputs() {
        return this.getInputContainer().getChildren();
    }

    @Override
    public String getText() {
        return this.textProperty.get();
    }

    public SimpleStringProperty textProperty() {
        return this.textProperty;
    }

    @Override
    public void setText(String text) {
        this.textProperty.set(text);
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
    }
}

