/*
 * Decompiled with CFR 0.152.
 */
package tornadofx.control;

import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import tornadofx.control.Field;
import tornadofx.control.Form;
import tornadofx.util.NodeHelper;

@DefaultProperty(value="children")
public class Fieldset
extends VBox {
    private static final PseudoClass HORIZONTAL_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"horizontal");
    private static final PseudoClass VERTICAL_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"vertical");
    private SimpleStringProperty text = new SimpleStringProperty();
    private ObjectProperty<Priority> inputGrow = new SimpleObjectProperty((Object)Priority.SOMETIMES);
    private ObjectProperty<Orientation> labelPosition = new SimpleObjectProperty();
    private ObjectProperty<Double> wrapWidth = new SimpleObjectProperty();
    private ObjectProperty<Node> icon = new SimpleObjectProperty();
    private Label legend;

    public Fieldset(String text) {
        this(text, Orientation.HORIZONTAL);
    }

    public Fieldset(String text, Orientation labelPosition) {
        this();
        this.setText(text);
        this.setLabelPosition(labelPosition);
    }

    public void add(Node child) {
        this.getChildren().add((Object)child);
    }

    public Field field(String text, Orientation orientation, Node ... inputs) {
        Field field = new Field(text, orientation, false, inputs);
        this.getChildren().add((Object)field);
        return field;
    }

    public Field field(String text, Node ... inputs) {
        Field field = new Field(text, inputs);
        this.getChildren().add((Object)field);
        return field;
    }

    public Field field() {
        Field field = new Field();
        this.getChildren().add((Object)field);
        return field;
    }

    public Field field(Node ... inputs) {
        Field field = new Field(null, inputs);
        this.getChildren().add((Object)field);
        return field;
    }

    public Fieldset() {
        this.getStyleClass().add((Object)"fieldset");
        this.syncOrientationState();
        this.textProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null && !newValue.isEmpty()) {
                this.addLegend();
            }
        });
        this.iconProperty().addListener((observable1, oldValue1, newValue) -> {
            if (newValue != null) {
                this.addLegend();
            }
        });
        this.syncHgrow();
        this.parentProperty().addListener((observable, oldParent, newParent) -> {
            Form newParentForm;
            Form oldParentForm;
            if (!(oldParent instanceof Form) && (oldParentForm = NodeHelper.findParentOfType((Node)oldParent, Form.class)) != null) {
                oldParentForm.getChildren().remove((Object)this);
            }
            if (!(newParent instanceof Form) && (newParentForm = NodeHelper.findParentOfType((Node)newParent, Form.class)) != null) {
                newParentForm.getChildren().remove((Object)this);
            }
        });
    }

    private void syncHgrow() {
        this.getChildren().addListener(c -> {
            while (c.next()) {
                if (!c.wasAdded()) continue;
                c.getAddedSubList().forEach(this::configureHgrow);
            }
        });
        this.inputGrowProperty().addListener((observable, oldValue, newValue) -> this.getChildren().stream().forEach(this::configureHgrow));
    }

    private void syncOrientationState() {
        this.labelPosition.addListener((observable, oldValue, newValue) -> {
            if (newValue == Orientation.HORIZONTAL) {
                this.pseudoClassStateChanged(VERTICAL_PSEUDOCLASS_STATE, false);
                this.pseudoClassStateChanged(HORIZONTAL_PSEUDOCLASS_STATE, true);
            } else {
                this.pseudoClassStateChanged(HORIZONTAL_PSEUDOCLASS_STATE, false);
                this.pseudoClassStateChanged(VERTICAL_PSEUDOCLASS_STATE, true);
            }
        });
        this.wrapWidth.addListener((observable, oldValue, newValue) -> {
            ObjectBinding responsiveOrientation = Bindings.createObjectBinding(() -> this.getWidth() < newValue ? Orientation.VERTICAL : Orientation.HORIZONTAL, (Observable[])new Observable[]{this.widthProperty()});
            if (this.labelPositionProperty().isBound()) {
                this.labelPositionProperty().unbind();
            }
            this.labelPositionProperty().bind((ObservableValue)responsiveOrientation);
        });
    }

    private void addLegend() {
        if (this.legend == null) {
            this.legend = new Label();
            this.legend.textProperty().bind((ObservableValue)this.textProperty());
            this.legend.getStyleClass().add((Object)"legend");
            this.getChildren().add(0, (Object)this.legend);
        }
        this.legend.setGraphic(this.getIcon());
    }

    private void configureHgrow(Node node) {
        HBox.setHgrow((Node)node, (Priority)this.getInputGrow());
        if (node instanceof Field) {
            ((Field)node).configureHGrow(this.getInputGrow());
        } else if (node instanceof Pane) {
            ((Pane)node).getChildren().forEach(child -> this.configureHgrow((Node)child));
        }
    }

    public Form getForm() {
        return NodeHelper.findParentOfType((Node)this, Form.class);
    }

    protected List<Field> getFields() {
        return NodeHelper.findChildrenOfType((Pane)this, Field.class);
    }

    public Priority getInputGrow() {
        return (Priority)this.inputGrow.get();
    }

    public ObjectProperty<Priority> inputGrowProperty() {
        return this.inputGrow;
    }

    public void setInputGrow(Priority inputGrow) {
        this.inputGrow.set((Object)inputGrow);
    }

    public String getText() {
        return this.text.get();
    }

    public SimpleStringProperty textProperty() {
        return this.text;
    }

    public void setText(String text) {
        this.text.set(text);
    }

    @Deprecated
    public Orientation getOrientation() {
        return this.getLabelPosition();
    }

    public Orientation getLabelPosition() {
        return (Orientation)this.labelPosition.get();
    }

    public ObjectProperty labelPositionProperty() {
        return this.labelPosition;
    }

    @Deprecated
    public ObjectProperty<Orientation> orientationProperty() {
        return this.labelPosition;
    }

    @Deprecated
    public void setOrientation(Orientation orientation) {
        this.setLabelPosition(orientation);
    }

    public void setLabelPosition(Orientation orientation) {
        this.labelPosition.set((Object)orientation);
    }

    public Double getWrapWidth() {
        return (Double)this.wrapWidth.get();
    }

    public ObjectProperty<Double> wrapWidthProperty() {
        return this.wrapWidth;
    }

    public void setWrapWidth(Double wrapWidth) {
        this.wrapWidth.set((Object)wrapWidth);
    }

    public Node getIcon() {
        return (Node)this.icon.get();
    }

    public ObjectProperty<Node> iconProperty() {
        return this.icon;
    }

    public void setIcon(Node icon) {
        this.icon.set((Object)icon);
    }
}

